/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.generic;

import coveredclass.org.apache.bcel.generic.BIPUSH;
import coveredclass.org.apache.bcel.generic.ClassGenException;
import coveredclass.org.apache.bcel.generic.CompoundInstruction;
import coveredclass.org.apache.bcel.generic.ConstantPoolGen;
import coveredclass.org.apache.bcel.generic.Instruction;
import coveredclass.org.apache.bcel.generic.InstructionConst;
import coveredclass.org.apache.bcel.generic.InstructionConstants;
import coveredclass.org.apache.bcel.generic.InstructionList;
import coveredclass.org.apache.bcel.generic.LDC;
import coveredclass.org.apache.bcel.generic.LDC2_W;
import coveredclass.org.apache.bcel.generic.ObjectType;
import coveredclass.org.apache.bcel.generic.SIPUSH;
import coveredclass.org.apache.bcel.generic.VariableLengthInstruction;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction,
InstructionConstants {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction instruction;

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int value) {
        this.instruction = value >= -1 && value <= 5 ? InstructionConst.getInstruction(3 + value) : (Instruction.isValidByte(value) ? new BIPUSH((byte)value) : (Instruction.isValidShort(value) ? new SIPUSH((short)value) : new LDC(cp.addInteger(value))));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean value) {
        this.instruction = InstructionConst.getInstruction(3 + (value ? 1 : 0));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float value) {
        this.instruction = (double)value == 0.0 ? InstructionConst.FCONST_0 : ((double)value == 1.0 ? InstructionConst.FCONST_1 : ((double)value == 2.0 ? InstructionConst.FCONST_2 : new LDC(cp.addFloat(value))));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long value) {
        this.instruction = value == 0L ? InstructionConst.LCONST_0 : (value == 1L ? InstructionConst.LCONST_1 : new LDC2_W(cp.addLong(value)));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown double value) {
        this.instruction = value == 0.0 ? InstructionConst.DCONST_0 : (value == 1.0 ? InstructionConst.DCONST_1 : new LDC2_W(cp.addDouble(value)));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String value) {
        this.instruction = value == null ? InstructionConst.ACONST_NULL : new LDC(cp.addString(value));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType value) {
        this.instruction = value == null ? InstructionConst.ACONST_NULL : new LDC(cp.addClass(value));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (int)value.intValue()).instruction;
        } else if (value instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (double)value.doubleValue()).instruction;
        } else if (value instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (float)value.floatValue()).instruction;
        } else if (value instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (long)value.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + value);
        }
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Character value) {
        this(cp, (int)value.charValue());
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Boolean value) {
        this(cp, (boolean)value);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction getInstruction() {
        return this.instruction;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.instruction + " (PUSH)";
    }
}

