/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.generic;

import coveredclass.org.apache.bcel.generic.ClassGenException;
import coveredclass.org.apache.bcel.generic.ConstantPoolGen;
import coveredclass.org.apache.bcel.generic.IndexedInstruction;
import coveredclass.org.apache.bcel.generic.Instruction;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.apache.bcel.generic.TypedInstruction;
import coveredclass.org.apache.bcel.util.ByteSequence;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.InternedDistinct;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class LocalVariableInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n = -1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short c_tag = (short)-1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short canon_tag = (short)-1;

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide(@UnknownInitialization(value=LocalVariableInstruction.class) LocalVariableInstruction this) {
        return this.n > 255;
    }

    LocalVariableInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short canon_tag, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short c_tag) {
        this.canon_tag = canon_tag;
        this.c_tag = c_tag;
    }

    LocalVariableInstruction() {
    }

    protected LocalVariableInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short c_tag, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        super(opcode, (short)2);
        this.c_tag = c_tag;
        this.canon_tag = opcode;
        this.setIndex(n);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (this.wide()) {
            out.writeByte(196);
        }
        out.writeByte(super.getOpcode());
        if (super.getLength() > 1) {
            if (this.wide()) {
                out.writeShort(this.n);
            } else {
                out.writeByte(this.n);
            }
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        short _opcode = super.getOpcode();
        if (_opcode >= 26 && _opcode <= 45 || _opcode >= 59 && _opcode <= 78) {
            return super.toString(verbose);
        }
        return super.toString(verbose) + " " + this.n;
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (wide) {
            this.n = bytes.readUnsignedShort();
            super.setLength(4);
        } else {
            short _opcode = super.getOpcode();
            if (_opcode >= 21 && _opcode <= 25 || _opcode >= 54 && _opcode <= 58) {
                this.n = bytes.readUnsignedByte();
                super.setLength(2);
            } else if (_opcode <= 45) {
                this.n = (_opcode - 26) % 4;
                super.setLength(1);
            } else {
                this.n = (_opcode - 59) % 4;
                super.setLength(1);
            }
        }
    }

    @Override
    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.n;
    }

    @Override
    public void setIndex(@UnknownInitialization(value=LocalVariableInstruction.class) LocalVariableInstruction this, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Illegal value: " + n);
        }
        this.n = n;
        if (n <= 3) {
            super.setOpcode((short)(this.c_tag + n));
            super.setLength(1);
        } else {
            super.setOpcode(this.canon_tag);
            if (this.wide()) {
                super.setLength(4);
            } else {
                super.setLength(2);
            }
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short getCanonicalTag() {
        return this.canon_tag;
    }

    @Override
    public @InternedDistinct @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        switch (this.canon_tag) {
            case 21: 
            case 54: {
                return Type.INT;
            }
            case 22: 
            case 55: {
                return Type.LONG;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
        }
        throw new ClassGenException("Oops: unknown case in switch" + this.canon_tag);
    }

    final void setIndexOnly(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        this.n = n;
    }
}

