/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.generic;

import coveredclass.org.apache.bcel.classfile.Utility;
import coveredclass.org.apache.bcel.generic.BranchHandle;
import coveredclass.org.apache.bcel.generic.BranchInstruction;
import coveredclass.org.apache.bcel.generic.ClassGenException;
import coveredclass.org.apache.bcel.generic.Instruction;
import coveredclass.org.apache.bcel.generic.InstructionTargeter;
import coveredclass.org.apache.bcel.generic.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.interning.qual.UsesObjectEquals;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@UsesObjectEquals
public class InstructionHandle {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle next;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle prev;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction instruction;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i_position = -1;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionTargeter> targeters;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object> attributes;

    @Deprecated
    protected void addHandle() {
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getNext() {
        return this.next;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getPrev() {
        return this.prev;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(@UnknownInitialization InstructionHandle this, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i) {
        if (i == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != BranchHandle.class && i instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + i + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = i;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction swapInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i) {
        Instruction oldInstruction = this.instruction;
        this.instruction = i;
        return oldInstruction;
    }

    protected InstructionHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i) {
        this.setInstruction(i);
    }

    static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getInstructionHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i) {
        return new InstructionHandle(i);
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int updatePosition(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int offset, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_offset) {
        this.i_position += offset;
        return 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getPosition() {
        return this.i_position;
    }

    void setPosition(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pos) {
        this.i_position = pos;
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.clear();
        }
    }

    public void removeTargeter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionTargeter t) {
        if (this.targeters != null) {
            this.targeters.remove(t);
        }
    }

    public void addTargeter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionTargeter t) {
        if (this.targeters == null) {
            this.targeters = new HashSet<InstructionTargeter>();
        }
        this.targeters.add(t);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionTargeter @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getTargeters() {
        if (!this.hasTargeters()) {
            return new InstructionTargeter[0];
        }
        InstructionTargeter[] t = new InstructionTargeter[this.targeters.size()];
        this.targeters.toArray(t);
        return t;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        return Utility.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(verbose);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.toString(true);
    }

    public void addAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object key, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object attr) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        this.attributes.put(key, attr);
    }

    public void removeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object getAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Collection<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        return this.attributes.values();
    }

    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        this.instruction.accept(v);
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle setNext(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle next) {
        this.next = next;
        return next;
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle setPrev(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle prev) {
        this.prev = prev;
        return prev;
    }
}

