/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.generic;

import coveredclass.org.apache.bcel.generic.BasicType;
import coveredclass.org.apache.bcel.generic.ClassGenException;
import coveredclass.org.apache.bcel.generic.ObjectType;
import coveredclass.org.apache.bcel.generic.ReferenceType;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.ClassGetName;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;

public final class ArrayType
extends ReferenceType {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type basic_type;

    public ArrayType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions) {
        this(BasicType.getType(type), dimensions);
    }

    public ArrayType(@ClassGetName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions) {
        this(ObjectType.getInstance(class_name), dimensions);
    }

    public ArrayType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int dimensions) {
        super((byte)13, "<dummy, will be replaced before end of constructor>");
        if (dimensions < 1 || dimensions > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + dimensions);
        }
        switch (type.getType()) {
            case 13: {
                ArrayType array = (ArrayType)type;
                this.dimensions = dimensions + array.dimensions;
                this.basic_type = array.basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = dimensions;
                this.basic_type = type;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            buf.append('[');
        }
        buf.append(this.basic_type.getSignature());
        super.setSignature(buf.toString());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getBasicType() {
        return this.basic_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getDimensions() {
        return this.dimensions;
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    @Override
    @EnsuresNonNullIf(result=true, expression={"#1"})
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object _type) {
        if (_type instanceof ArrayType) {
            ArrayType array = (ArrayType)_type;
            return array.dimensions == this.dimensions && array.basic_type.equals(this.basic_type);
        }
        return false;
    }
}

