/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.Node;
import coveredclass.org.apache.bcel.classfile.Utility;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleRequires
implements Cloneable,
Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int requires_index;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int requires_flags;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int requires_version_index;

    ModuleRequires(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.requires_index = file.readUnsignedShort();
        this.requires_flags = file.readUnsignedShort();
        this.requires_version_index = file.readUnsignedShort();
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModuleRequires(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.requires_index);
        file.writeShort(this.requires_flags);
        file.writeShort(this.requires_version_index);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "requires(" + this.requires_index + ", " + String.format("%04x", this.requires_flags) + ", " + this.requires_version_index + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String module_name = constant_pool.constantToString(this.requires_index, (byte)19);
        buf.append(Utility.compactClassName(module_name, false));
        buf.append(", ").append(String.format("%04x", this.requires_flags));
        String version = this.requires_version_index == 0 ? "0" : constant_pool.getConstantString(this.requires_version_index, (byte)1);
        buf.append(", ").append(version);
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleRequires copy() {
        try {
            return (ModuleRequires)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

