/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.Node;
import coveredclass.org.apache.bcel.classfile.Utility;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleProvides
implements Cloneable,
Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int provides_index;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int provides_with_count;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] provides_with_index;

    ModuleProvides(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.provides_index = file.readUnsignedShort();
        this.provides_with_count = file.readUnsignedShort();
        this.provides_with_index = new int[this.provides_with_count];
        for (int i = 0; i < this.provides_with_count; ++i) {
            this.provides_with_index[i] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModuleProvides(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.provides_index);
        file.writeShort(this.provides_with_count);
        for (int entry : this.provides_with_index) {
            file.writeShort(entry);
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "provides(" + this.provides_index + ", " + this.provides_with_count + ", ...)";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String interface_name = constant_pool.constantToString(this.provides_index, (byte)7);
        buf.append(Utility.compactClassName(interface_name, false));
        buf.append(", with(").append(this.provides_with_count).append("):\n");
        for (int index : this.provides_with_index) {
            String class_name = constant_pool.getConstantString(index, (byte)7);
            buf.append("      ").append(Utility.compactClassName(class_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleProvides copy() {
        try {
            return (ModuleProvides)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

