/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.Utility;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModulePackages
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] package_index_table;

    public ModulePackages(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModulePackages c) {
        this(c.getNameIndex(), c.getLength(), c.getPackageIndexTable(), c.getConstantPool());
    }

    public ModulePackages(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] package_index_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)23, name_index, length, constant_pool);
        this.package_index_table = package_index_table != null ? package_index_table : new int[]{};
    }

    ModulePackages(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_packages = input.readUnsignedShort();
        this.package_index_table = new int[number_of_packages];
        for (int i = 0; i < number_of_packages; ++i) {
            this.package_index_table[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModulePackages(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.package_index_table.length);
        for (int index : this.package_index_table) {
            file.writeShort(index);
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getPackageIndexTable() {
        return this.package_index_table;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumberOfPackages() {
        return this.package_index_table == null ? 0 : this.package_index_table.length;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getPackageNames() {
        String[] names = new String[this.package_index_table.length];
        for (int i = 0; i < this.package_index_table.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.package_index_table[i], (byte)20).replace('/', '.');
        }
        return names;
    }

    public void setPackageIndexTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] package_index_table) {
        this.package_index_table = package_index_table != null ? package_index_table : new int[]{};
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModulePackages(");
        buf.append(this.package_index_table.length);
        buf.append("):\n");
        for (int index : this.package_index_table) {
            String package_name = super.getConstantPool().getConstantString(index, (byte)20);
            buf.append("  ").append(Utility.compactClassName(package_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        ModulePackages c = (ModulePackages)this.clone();
        if (this.package_index_table != null) {
            c.package_index_table = new int[this.package_index_table.length];
            System.arraycopy(this.package_index_table, 0, c.package_index_table, 0, this.package_index_table.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

