/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.ConstantUtf8;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodParameter
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags;

    public MethodParameter() {
    }

    MethodParameter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.name_index = input.readUnsignedShort();
        this.access_flags = input.readUnsignedShort();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.name_index;
    }

    public void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index) {
        this.name_index = name_index;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getParameterName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        if (this.name_index == 0) {
            return null;
        }
        return ((ConstantUtf8)constant_pool.getConstant(this.name_index, (byte)1)).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags) {
        this.access_flags = access_flags;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isSynthetic() {
        return (this.access_flags & 0x1000) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isMandated() {
        return (this.access_flags & Short.MIN_VALUE) != 0;
    }

    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitMethodParameter(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.name_index);
        file.writeShort(this.access_flags);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

