/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.classfile;

import coveredclass.org.apache.bcel.classfile.Attribute;
import coveredclass.org.apache.bcel.classfile.CodeException;
import coveredclass.org.apache.bcel.classfile.ConstantPool;
import coveredclass.org.apache.bcel.classfile.LineNumberTable;
import coveredclass.org.apache.bcel.classfile.LocalVariableTable;
import coveredclass.org.apache.bcel.classfile.Utility;
import coveredclass.org.apache.bcel.classfile.Visitor;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Code
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_stack;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_locals;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] code;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exception_table;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes;

    public Code(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Code c) {
        this(c.getNameIndex(), c.getLength(), c.getMaxStack(), c.getMaxLocals(), c.getCode(), c.getExceptionTable(), c.getAttributes(), c.getConstantPool());
    }

    Code(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), null, null, null, constant_pool);
        int code_length = file.readInt();
        this.code = new byte[code_length];
        file.readFully(this.code);
        int exception_table_length = file.readUnsignedShort();
        this.exception_table = new CodeException[exception_table_length];
        for (int i = 0; i < exception_table_length; ++i) {
            this.exception_table[i] = new CodeException(file);
        }
        int attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
        super.setLength(length);
    }

    public Code(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_stack, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_locals, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown [] code, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown [] exception_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)2, name_index, length, constant_pool);
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.code = code != null ? code : new byte[]{};
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitCode(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.max_stack);
        file.writeShort(this.max_locals);
        file.writeInt(this.code.length);
        file.write(this.code, 0, this.code.length);
        file.writeShort(this.exception_table.length);
        for (CodeException codeException : this.exception_table) {
            codeException.dump(file);
        }
        file.writeShort(this.attributes.length);
        for (Cloneable cloneable : this.attributes) {
            ((Attribute)cloneable).dump(file);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAttributes() {
        return this.attributes;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LineNumberTable getLineNumberTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LineNumberTable)) continue;
            return (LineNumberTable)attribute;
        }
        return null;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LocalVariableTable getLocalVariableTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LocalVariableTable)) continue;
            return (LocalVariableTable)attribute;
        }
        return null;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getCode() {
        return this.code;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionTable() {
        return this.exception_table;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxLocals() {
        return this.max_locals;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxStack() {
        return this.max_stack;
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getInternalLength() {
        return 8 + this.code.length + 2 + 8 * (this.exception_table == null ? 0 : this.exception_table.length) + 2;
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int calculateLength() {
        int len = 0;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                len += attribute.getLength() + 6;
            }
        }
        return len + this.getInternalLength();
    }

    public void setAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes) {
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    public void setCode(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] code) {
        this.code = code != null ? code : new byte[]{};
        super.setLength(this.calculateLength());
    }

    public void setExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exception_table) {
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        super.setLength(this.calculateLength());
    }

    public void setMaxLocals(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_locals) {
        this.max_locals = max_locals;
    }

    public void setMaxStack(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_stack) {
        this.max_stack = max_stack;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        StringBuilder buf = new StringBuilder(100);
        buf.append("Code(max_stack = ").append(this.max_stack).append(", max_locals = ").append(this.max_locals).append(", code_length = ").append(this.code.length).append(")\n").append(Utility.codeToString(this.code, super.getConstantPool(), 0, -1, verbose));
        if (this.exception_table.length > 0) {
            buf.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            for (Cloneable cloneable : this.exception_table) {
                buf.append(((CodeException)cloneable).toString(super.getConstantPool(), verbose)).append("\n");
            }
        }
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s) = ");
            for (Cloneable cloneable : this.attributes) {
                buf.append("\n").append(((Attribute)cloneable).getName()).append(":");
                buf.append("\n").append(cloneable);
            }
        }
        return buf.toString();
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.toString(true);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        int i;
        Code c = (Code)this.clone();
        if (this.code != null) {
            c.code = new byte[this.code.length];
            System.arraycopy(this.code, 0, c.code, 0, this.code.length);
        }
        c.setConstantPool(_constant_pool);
        c.exception_table = new CodeException[this.exception_table.length];
        for (i = 0; i < this.exception_table.length; ++i) {
            c.exception_table[i] = this.exception_table[i].copy();
        }
        c.attributes = new Attribute[this.attributes.length];
        for (i = 0; i < this.attributes.length; ++i) {
            c.attributes[i] = this.attributes[i].copy(_constant_pool);
        }
        return c;
    }
}

