/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import randoop.Globals;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.util.UtilPlume;

public final class Util {
    private Util() {
        throw new IllegalStateException("no instance");
    }

    public static @SignatureUnknown boolean iff(@SignatureUnknown boolean a, @SignatureUnknown boolean b) {
        return a == b;
    }

    public static @SignatureUnknown boolean implies(@SignatureUnknown boolean a, @SignatureUnknown boolean b) {
        return !a || b;
    }

    public static @SignatureUnknown boolean isJavaIdentifier(@SignatureUnknown String s2) {
        if (s2 == null || s2.length() == 0 || !Character.isJavaIdentifierStart(s2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s2.length(); ++i) {
            if (Character.isJavaIdentifierPart(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static @SignatureUnknown String convertToHexString(@SignatureUnknown String unicodeString) {
        char[] chars = unicodeString.toCharArray();
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            output.append("\\u");
            String hex = Integer.toHexString(chars[i]);
            if (hex.length() < 4) {
                output.append("0");
            }
            if (hex.length() < 3) {
                output.append("0");
            }
            if (hex.length() < 2) {
                output.append("0");
            }
            if (hex.length() < 1) {
                output.append("0");
            }
            output.append(hex);
        }
        return output.toString();
    }

    public static @SignatureUnknown int occurCount(@SignatureUnknown StringBuilder text, @SignatureUnknown String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("empty pattern");
        }
        int i = 0;
        int currIdx = text.indexOf(pattern);
        while (currIdx != -1) {
            ++i;
            currIdx = text.indexOf(pattern, currIdx + 1);
        }
        return i;
    }

    public static @SignatureUnknown String hangingParagraph(@SignatureUnknown String string, @SignatureUnknown int colWidth, @SignatureUnknown int indentWidth) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null.");
        }
        if (indentWidth > colWidth) {
            throw new IllegalArgumentException("indentWidth cannot be greater than columnWidth");
        }
        String indentString = new String(new char[indentWidth]).replace("\u0000", " ");
        StringBuilder b = new StringBuilder();
        boolean firstLine = true;
        while (true) {
            int i;
            int lineLength;
            int n = lineLength = firstLine ? colWidth : colWidth - indentWidth;
            if (lineLength > string.length()) {
                if (!firstLine) {
                    b.append(indentString);
                }
                b.append(string);
                return b.toString();
            }
            for (i = lineLength; i > 0 && !Character.isWhitespace(string.charAt(i)); --i) {
            }
            if (i == 0) {
                i = lineLength;
            }
            if (!firstLine) {
                b.append(indentString);
            }
            b.append(string.substring(0, i));
            b.append(Globals.lineSep);
            string = string.substring(i + 1);
            firstLine = false;
        }
    }

    public static @SignatureUnknown String replaceWords(@SignatureUnknown String text, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> replacements) {
        Pattern namesPattern = Pattern.compile("\\b(" + UtilPlume.join((CharSequence)"|", replacements.keySet().toArray()) + ")\\b");
        Matcher namesMatcher = namesPattern.matcher(text);
        StringBuilder b = new StringBuilder();
        int position = 0;
        while (namesMatcher.find(position)) {
            b.append(text.substring(position, namesMatcher.start(1)));
            b.append(replacements.get(namesMatcher.group(1)));
            position = namesMatcher.end(1);
        }
        b.append(text.substring(position));
        return b.toString();
    }
}

