/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class TupleSet<@SignatureBottom E> {
    private @SignatureUnknown List<@SignatureUnknown List<E>> tuples;
    private @SignatureUnknown int tupleLength;

    public TupleSet() {
        this.tuples = new ArrayList<List<E>>();
        this.tuples.add(new ArrayList());
        this.tupleLength = 0;
    }

    private TupleSet(@SignatureUnknown List<@SignatureUnknown List<E>> tuples, @SignatureUnknown int tupleLength) {
        this.tuples = tuples;
        this.tupleLength = tupleLength;
    }

    public @SignatureUnknown List<@SignatureUnknown List<E>> tuples() {
        return this.tuples;
    }

    public @SignatureUnknown TupleSet<E> extend(@SignatureUnknown List<E> elements) {
        ArrayList<List<List<E>>> tupleList = new ArrayList<List<List<E>>>(this.tuples.size() * elements.size());
        for (List<E> tuple : this.tuples) {
            for (E e : elements) {
                List<E> extTuple = this.extendTuple(tuple, e);
                assert (extTuple.size() == this.tupleLength + 1) : "tuple lengths don't match, expected " + this.tupleLength + " have " + extTuple.size();
                tupleList.add(extTuple);
            }
        }
        return new TupleSet<E>(tupleList, this.tupleLength + 1);
    }

    public @SignatureUnknown TupleSet<E> exhaustivelyExtend(@SignatureUnknown List<E> elements) {
        ArrayList<List<List<E>>> tupleList = new ArrayList<List<List<E>>>(this.tuples.size() * (this.tupleLength + 1));
        for (List<E> tuple : this.tuples) {
            for (E e : elements) {
                for (int i = 0; i <= tuple.size(); ++i) {
                    tupleList.add(this.insertInTuple(tuple, e, i));
                }
            }
        }
        return new TupleSet<E>(tupleList, this.tupleLength + 1);
    }

    private @SignatureUnknown List<E> extendTuple(@SignatureUnknown List<E> tuple, E e) {
        ArrayList<E> extTuple = new ArrayList<E>(this.tupleLength + 1);
        extTuple.addAll(tuple);
        extTuple.add(e);
        return extTuple;
    }

    private @SignatureUnknown List<E> insertInTuple(@SignatureUnknown List<E> tuple, E e, @SignatureUnknown int i) {
        ArrayList<E> extTuple = new ArrayList<E>(this.tupleLength + 1);
        extTuple.addAll(tuple);
        extTuple.add(i, e);
        return extTuple;
    }
}

