/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import randoop.Globals;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class TestCoverageInfo {
    public final @SignatureUnknown int @SignatureUnknown [] branchTrue;
    public final @SignatureUnknown int @SignatureUnknown [] branchFalse;
    public final @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown Set<@SignatureUnknown Integer>> methodToIndices;

    public TestCoverageInfo(@SignatureUnknown int totalBranches, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown Set<@SignatureUnknown Integer>> map) {
        if (totalBranches < 0) {
            throw new IllegalArgumentException();
        }
        this.branchTrue = new int[totalBranches];
        this.branchFalse = new int[totalBranches];
        this.methodToIndices = Collections.unmodifiableMap(map);
    }

    private @SignatureUnknown String getCoverageInfo() {
        StringBuilder b = new StringBuilder();
        int totalBranchesCovered = 0;
        int totalBranches = 0;
        for (Map.Entry<String, Set<Integer>> entry : this.methodToIndices.entrySet()) {
            String methodSignature = entry.getKey();
            BranchCov covAndTot = this.getCoverageInfo(methodSignature);
            int branchesCovered = covAndTot.covered;
            int branchesInMethod = covAndTot.inMethod;
            totalBranchesCovered += branchesCovered;
            totalBranches += branchesInMethod;
            double percentCovered = (double)branchesCovered / (double)branchesInMethod;
            b.append((methodSignature == null ? "other" : methodSignature) + ": " + branchesCovered + "/" + branchesInMethod + " (" + percentCovered + "%)" + Globals.lineSep);
        }
        double totalPercent = (double)totalBranchesCovered / (double)totalBranches;
        b.append("TOTAL :" + totalBranchesCovered + "/" + totalBranches + " (" + totalPercent + "%)" + Globals.lineSep);
        return b.toString();
    }

    private @SignatureUnknown BranchCov getCoverageInfo(@SignatureUnknown String methodSignature) {
        Set<Integer> indices = this.methodToIndices.get(methodSignature);
        int totalBranches = indices.size() * 2;
        int branchesCovered = 0;
        for (Integer i : indices) {
            if (this.branchTrue[i] > 0) {
                ++branchesCovered;
            }
            if (this.branchFalse[i] <= 0) continue;
            ++branchesCovered;
        }
        assert (branchesCovered <= totalBranches);
        return new BranchCov(branchesCovered, totalBranches);
    }

    public static @SignatureUnknown String getCoverageInfo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> clazz) {
        if (!TestCoverageInfo.isInstrumented(clazz)) {
            return "Class<?> not instrumented for branch coverage: " + clazz.getName();
        }
        try {
            return TestCoverageInfo.getCoverageInfoObject(clazz).getCoverageInfo();
        }
        catch (Exception e) {
            throw new RandoopBug(e);
        }
    }

    private static @SignatureUnknown TestCoverageInfo getCoverageInfoObject(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> clazz) throws @SignatureUnknown IllegalArgumentException, @SignatureUnknown SecurityException, @SignatureUnknown IllegalAccessException, @SignatureUnknown NoSuchFieldException {
        Field f = clazz.getDeclaredField("randoopCoverageInfo");
        f.setAccessible(true);
        return (TestCoverageInfo)f.get(null);
    }

    private static @SignatureUnknown boolean isInstrumented(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals("randoopCoverageInfo")) continue;
            return true;
        }
        return false;
    }

    private static class BranchCov {
        final @SignatureUnknown int covered;
        final @SignatureUnknown int inMethod;

        BranchCov(@SignatureUnknown int covered, @SignatureUnknown int inMethod) {
            this.covered = covered;
            this.inMethod = inMethod;
        }
    }
}

