/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.lang.reflect.InvocationTargetException;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.options.Option;
import randoop.org.plumelib.options.OptionGroup;
import randoop.util.Log;
import randoop.util.ReflectionCode;
import randoop.util.RunnerThread;
import randoop.util.TimeoutExceededException;

public final class ReflectionExecutor {
    @OptionGroup(value="Threading")
    @Option(value="Execute each test in a separate thread, with timeout")
    public static @SignatureUnknown boolean usethreads = false;
    public static @SignatureUnknown int CALL_TIMEOUT_DEFAULT;
    @Option(value="Maximum number of milliseconds a test may run. Only meaningful with --usethreads")
    public static @SignatureUnknown int call_timeout;
    private static @SignatureUnknown long normal_exec_duration;
    private static @SignatureUnknown int normal_exec_count;
    private static @SignatureUnknown long excep_exec_duration;
    private static @SignatureUnknown int excep_exec_count;

    private ReflectionExecutor() {
        throw new Error("Do not instantiate");
    }

    public static void resetStatistics() {
        normal_exec_duration = 0L;
        normal_exec_count = 0;
        excep_exec_duration = 0L;
        excep_exec_count = 0;
    }

    public static @SignatureUnknown int normalExecs() {
        return normal_exec_count;
    }

    public static @SignatureUnknown int excepExecs() {
        return excep_exec_count;
    }

    public static @SignatureUnknown double normalExecAvgMillis() {
        return (double)normal_exec_duration / (double)normal_exec_count / Math.pow(10.0, 6.0);
    }

    public static @SignatureUnknown double excepExecAvgMillis() {
        return (double)excep_exec_duration / (double)excep_exec_count / Math.pow(10.0, 6.0);
    }

    public static @SignatureUnknown ExecutionOutcome executeReflectionCode(@SignatureUnknown ReflectionCode code) {
        long start = System.nanoTime();
        if (usethreads) {
            try {
                ReflectionExecutor.executeReflectionCodeThreaded(code);
            }
            catch (TimeoutExceededException e) {
                return new ExceptionalExecution(e, call_timeout * 1000);
            }
        } else {
            ReflectionExecutor.executeReflectionCodeUnThreaded(code);
        }
        long duration = System.nanoTime() - start;
        if (code.getExceptionThrown() != null) {
            assert ((excep_exec_duration += duration) > 0L);
            ++excep_exec_count;
            return new ExceptionalExecution(code.getExceptionThrown(), duration);
        }
        assert ((normal_exec_duration += duration) > 0L);
        ++normal_exec_count;
        return new NormalExecution(code.getReturnValue(), duration);
    }

    private static void executeReflectionCodeThreaded(@SignatureUnknown ReflectionCode code) throws @SignatureUnknown TimeoutExceededException {
        RunnerThread runnerThread = new RunnerThread(null);
        runnerThread.setup(code);
        try {
            runnerThread.start();
            runnerThread.join(call_timeout);
            if (!runnerThread.runFinished) {
                Log.logPrintf("Exceeded timeout: aborting execution of call: %s%n", runnerThread.getCode());
                runnerThread.stop();
                throw new TimeoutExceededException();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("A RunnerThread thread shouldn't be interrupted by anyone! (This may be a bug in Randoop; please report it at https://github.com/randoop/randoop/issues , providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .)");
        }
    }

    private static void executeReflectionCodeUnThreaded(@SignatureUnknown ReflectionCode code) {
        try {
            code.runReflectionCode();
            return;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (ReflectionCode.ReflectionCodeException e) {
            throw new RandoopBug("code=" + code, e);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                throw new RandoopBug("Unexpected InvocationTargetException", e);
            }
            throw e;
        }
    }

    static {
        call_timeout = CALL_TIMEOUT_DEFAULT = 5000;
        normal_exec_duration = 0L;
        normal_exec_count = 0;
        excep_exec_duration = 0L;
        excep_exec_count = 0;
    }
}

