/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class ReflectionCode {
    private @SignatureUnknown boolean hasStarted;
    private @SignatureUnknown boolean hasRun;
    protected @SignatureUnknown Object retval;
    protected @SignatureUnknown Throwable exceptionThrown;

    public final @SignatureUnknown boolean hasStarted() {
        return this.hasStarted;
    }

    public final @SignatureUnknown boolean hasRun() {
        return this.hasRun;
    }

    protected final void setHasStarted() {
        if (this.hasStarted) {
            throw new ReflectionCodeException("cannot run this twice");
        }
        this.hasStarted = true;
    }

    protected final void setHasRun() {
        if (this.hasRun) {
            throw new ReflectionCodeException("cannot run this twice");
        }
        this.hasRun = true;
    }

    public final void runReflectionCode() throws @SignatureUnknown ReflectionCodeException {
        this.setHasStarted();
        this.runReflectionCodeRaw();
        this.setHasRun();
    }

    protected abstract void runReflectionCodeRaw() throws @SignatureUnknown ReflectionCodeException;

    public @SignatureUnknown Object getReturnValue() {
        if (!this.hasRun()) {
            throw new IllegalStateException("run first, then ask");
        }
        return this.retval;
    }

    public @SignatureUnknown Throwable getExceptionThrown() {
        if (!this.hasRun()) {
            throw new IllegalStateException("run first, then ask");
        }
        return this.exceptionThrown;
    }

    protected @SignatureUnknown String status() {
        if (!this.hasStarted() && !this.hasRun()) {
            return " not run yet";
        }
        if (this.hasStarted() && !this.hasRun()) {
            return " failed to run";
        }
        if (!this.hasStarted() && this.hasRun()) {
            return " ILLEGAL STATE";
        }
        if (this.exceptionThrown == null) {
            return " returned: " + this.retval;
        }
        return " threw: " + this.exceptionThrown;
    }

    static final class ReflectionCodeException
    extends IllegalStateException {
        private static final @SignatureUnknown long serialVersionUID = -7508201027241079866L;

        ReflectionCodeException(@SignatureUnknown String msg) {
            super(msg);
        }

        ReflectionCodeException(@SignatureUnknown String msg, @SignatureUnknown Throwable cause) {
            super(msg, cause);
        }

        ReflectionCodeException(@SignatureUnknown Throwable cause) {
            super(cause);
        }
    }
}

