/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.util.UtilPlume;
import randoop.util.RecordProcessor;

public class RecordListReader {
    private final @SignatureUnknown String startMarker;
    private final @SignatureUnknown String endMarker;
    private final @SignatureUnknown RecordProcessor processor;

    public RecordListReader(@SignatureUnknown String recordType, @SignatureUnknown RecordProcessor proc) {
        if (recordType == null || recordType.length() == 0) {
            throw new IllegalArgumentException("No record type given: " + (recordType == null ? "null" : "\"\""));
        }
        if (proc == null) {
            throw new IllegalArgumentException("proc cannot be null.");
        }
        this.processor = proc;
        this.startMarker = "START " + recordType;
        this.endMarker = "END " + recordType;
    }

    public void parse(@SignatureUnknown String inFile) {
        BufferedReader reader;
        if (inFile == null || inFile.length() == 0) {
            throw new IllegalArgumentException("Illegal input file name: " + inFile);
        }
        try {
            reader = UtilPlume.bufferedFileReader(inFile);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.parse(reader);
    }

    public void parse(@SignatureUnknown Path inFile) {
        BufferedReader reader;
        if (inFile == null) {
            throw new IllegalArgumentException("Null input file");
        }
        try {
            reader = UtilPlume.bufferedFileReader(inFile.toFile());
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.parse(reader);
    }

    public void parse(@SignatureUnknown BufferedReader reader) {
        try {
            String line = RecordListReader.nextNWCLine(reader);
            while (line != null) {
                if (!(line = line.trim()).startsWith(this.startMarker)) {
                    throw new IllegalArgumentException("Expected \"" + this.startMarker + "\" but got " + line);
                }
                List<String> oneRecord = this.readOneRecord(reader);
                this.processor.processRecord(oneRecord);
                line = RecordListReader.nextNWCLine(reader);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private @SignatureUnknown List<@SignatureUnknown String> readOneRecord(@SignatureUnknown BufferedReader reader) throws @SignatureUnknown IOException {
        ArrayList<String> ret = new ArrayList<String>();
        String line = RecordListReader.nextNWCLine(reader);
        while (line != null && !line.equals(this.endMarker)) {
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            ret.add(line);
            line = RecordListReader.nextNWCLine(reader);
        }
        return ret;
    }

    private static @SignatureUnknown String nextNWCLine(@SignatureUnknown BufferedReader reader) throws @SignatureUnknown IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (line != null && (line.length() == 0 || line.indexOf(35) == 0)) {
            line = reader.readLine();
            if (line == null) continue;
            line = line.trim();
        }
        return line;
    }
}

