/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.SimpleList;

public class ListOfLists<@SignatureBottom T>
implements SimpleList<T>,
Serializable {
    private static final @SignatureUnknown long serialVersionUID = -3307714585442970263L;
    public final @SignatureUnknown List<@SignatureUnknown SimpleList<T>> lists;
    private @SignatureUnknown int @SignatureUnknown [] cumulativeSize;
    private @SignatureUnknown int totalelements;

    public ListOfLists(SimpleList<T> ... lists) {
        this.lists = new ArrayList<SimpleList<T>>(lists.length);
        for (SimpleList<T> sl : lists) {
            this.lists.add(sl);
        }
        this.cumulativeSize = new int[lists.length];
        this.totalelements = 0;
        for (int i = 0; i < lists.length; ++i) {
            SimpleList<T> l = lists[i];
            if (l == null) {
                throw new IllegalArgumentException("All lists should be non-null");
            }
            this.totalelements += l.size();
            this.cumulativeSize[i] = this.totalelements;
        }
    }

    public ListOfLists(@SignatureUnknown List<@SignatureUnknown SimpleList<T>> lists) {
        if (lists == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.lists = lists;
        this.cumulativeSize = new int[lists.size()];
        this.totalelements = 0;
        for (int i = 0; i < lists.size(); ++i) {
            SimpleList<T> l = lists.get(i);
            if (l == null) {
                throw new IllegalArgumentException("All lists should be non-null");
            }
            this.totalelements += l.size();
            this.cumulativeSize[i] = this.totalelements;
        }
    }

    @Override
    public @SignatureUnknown int size() {
        return this.totalelements;
    }

    @Override
    public @SignatureUnknown boolean isEmpty() {
        return this.totalelements == 0;
    }

    @Override
    public T get(@SignatureUnknown int index) {
        if (index < 0 || index > this.totalelements - 1) {
            throw new IllegalArgumentException("index must be between 0 and size()-1");
        }
        int previousListSize = 0;
        for (int i = 0; i < this.cumulativeSize.length; ++i) {
            if (index < this.cumulativeSize[i]) {
                return this.lists.get(i).get(index - previousListSize);
            }
            previousListSize = this.cumulativeSize[i];
        }
        throw new RandoopBug("Indexing error in ListOfLists");
    }

    @Override
    public @SignatureUnknown SimpleList<T> getSublist(@SignatureUnknown int index) {
        if (index < 0 || index > this.totalelements - 1) {
            throw new IllegalArgumentException("index must be between 0 and size()-1");
        }
        int previousListSize = 0;
        for (int i = 0; i < this.cumulativeSize.length; ++i) {
            if (index < this.cumulativeSize[i]) {
                return this.lists.get(i).getSublist(index - previousListSize);
            }
            previousListSize = this.cumulativeSize[i];
        }
        throw new RandoopBug("indexing error in ListOfLists");
    }

    @Override
    public @SignatureUnknown List<T> toJDKList() {
        ArrayList<T> result = new ArrayList<T>();
        for (SimpleList<T> l : this.lists) {
            result.addAll(l.toJDKList());
        }
        return result;
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.toJDKList().toString();
    }
}

