/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.util.CollectionsExt;

public class JarReader {
    private static @SignatureUnknown boolean debug = false;

    private JarReader() {
        throw new Error("Do not instantiate");
    }

    public static void main(@SignatureUnknown String @SignatureUnknown [] args) throws @SignatureUnknown IOException {
        List<String> names = JarReader.getClasseNamesInJar(args[0]);
        Collections.sort(names);
        System.out.println(CollectionsExt.toStringInLines(names));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @SignatureUnknown List<@SignatureUnknown String> getClassNamesInPackage(@SignatureUnknown String jarName, @SignatureUnknown String packageName) throws @SignatureUnknown IOException {
        ArrayList<String> classes = new ArrayList<String>();
        packageName = packageName.replaceAll("\\.", "/");
        if (debug) {
            System.out.println("Jar " + jarName + " looking for " + packageName);
        }
        try (ZipInputStream jarFile = null;){
            JarEntry jarEntry;
            jarFile = new JarInputStream(new FileInputStream(jarName));
            while ((jarEntry = ((JarInputStream)jarFile).getNextJarEntry()) != null) {
                if (!jarEntry.getName().startsWith(packageName) || !jarEntry.getName().endsWith(".class")) continue;
                if (debug) {
                    System.out.println(jarEntry.getName().replaceAll("/", "\\."));
                }
                classes.add(jarEntry.getName().replaceAll("/", "\\."));
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @SignatureUnknown List<@SignatureUnknown String> getClasseNamesInJar(@SignatureUnknown String jarName) throws @SignatureUnknown IOException {
        ArrayList<String> classes = new ArrayList<String>();
        if (debug) {
            System.out.println("Jar " + jarName);
        }
        try (ZipInputStream jarFile = null;){
            JarEntry jarEntry;
            jarFile = new JarInputStream(new FileInputStream(jarName));
            while ((jarEntry = ((JarInputStream)jarFile).getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                if (debug) {
                    System.out.println(jarEntry.getName().replaceAll("/", "\\."));
                }
                classes.add(jarEntry.getName().replaceAll("/", "\\."));
            }
        }
        return classes;
    }
}

