/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class CountDownTimer {
    private @SignatureUnknown long totalTime;
    private @SignatureUnknown long startTime;

    private CountDownTimer(@SignatureUnknown long timeMillis) {
        this.totalTime = timeMillis;
        this.startTime = System.currentTimeMillis();
    }

    public @SignatureUnknown boolean reachedZero() {
        return this.elapsedTime() >= this.totalTime;
    }

    public @SignatureUnknown long elapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public @SignatureUnknown long remainingTime() {
        long remainingTime = this.totalTime - this.elapsedTime();
        if (remainingTime < 0L) {
            return 0L;
        }
        return remainingTime;
    }

    public static @SignatureUnknown CountDownTimer createAndStart(@SignatureUnknown long totalTimeMillis) {
        return new CountDownTimer(totalTimeMillis);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "elapsed: " + this.elapsedTime() + ", remaining: " + this.remainingTime();
    }
}

