/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.Log;
import randoop.util.ReflectionCode;

public final class ConstructorReflectionCode
extends ReflectionCode {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> constructor;
    private final @SignatureUnknown Object @SignatureUnknown [] inputs;

    public ConstructorReflectionCode(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> constructor, @SignatureUnknown Object @SignatureUnknown [] inputs) {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor is null");
        }
        if (inputs == null) {
            throw new IllegalArgumentException("inputs is null");
        }
        this.constructor = constructor;
        this.inputs = inputs;
        if (!this.constructor.isAccessible()) {
            this.constructor.setAccessible(true);
            Log.logPrintf("not accessible: %s%n", this.constructor);
        }
    }

    @Override
    public void runReflectionCodeRaw() {
        try {
            this.retval = this.constructor.newInstance(this.inputs);
        }
        catch (InvocationTargetException e) {
            this.exceptionThrown = e.getCause();
        }
        catch (Throwable e) {
            throw new ReflectionCode.ReflectionCodeException(e);
        }
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "Call to " + this.constructor + ", args: " + Arrays.toString(this.inputs) + this.status();
    }
}

