/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import randoop.Globals;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.util.UtilPlume;

public final class CollectionsExt {
    private CollectionsExt() {
        throw new IllegalStateException("no instances");
    }

    static <T> T getNthIteratedElement(@SignatureUnknown Collection<@SignatureBottom ? extends T> s2, @SignatureUnknown int index) {
        if (s2 == null) {
            throw new IllegalArgumentException("s cannot be null.");
        }
        if (s2.isEmpty()) {
            throw new IllegalArgumentException("s cannot be empty.");
        }
        if (index >= s2.size()) {
            throw new IllegalArgumentException("Index " + index + " out of bounds for set of size " + s2.size());
        }
        return CollectionsExt.getNthIteratedElement(s2.iterator(), index);
    }

    private static <T> T getNthIteratedElement(@SignatureUnknown Iterator<@SignatureBottom ? extends T> iter, @SignatureUnknown int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index " + index + " out of bounds");
        }
        int counter = 0;
        while (iter.hasNext()) {
            if (counter == index) {
                return iter.next();
            }
            iter.next();
            ++counter;
        }
        throw new IllegalArgumentException("index " + index + " out of bounds, size=" + counter);
    }

    static @SignatureUnknown String toStringInLines(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Collection<@SignatureUnknown @SignatureBottom ?> c) {
        if (c.isEmpty()) {
            return "";
        }
        return UtilPlume.joinLines(CollectionsExt.toStringLines(c)) + Globals.lineSep;
    }

    private static @SignatureUnknown List<@SignatureUnknown String> toStringLines(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Collection<@SignatureUnknown @SignatureBottom ?> c) {
        ArrayList<String> lines = new ArrayList<String>(c.size());
        for (Object each : c) {
            lines.add(String.valueOf(each));
        }
        return lines;
    }
}

