/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import randoop.Globals;
import randoop.operation.NonreceiverTerm;
import randoop.org.apache.bcel.classfile.ClassParser;
import randoop.org.apache.bcel.classfile.Constant;
import randoop.org.apache.bcel.classfile.ConstantClass;
import randoop.org.apache.bcel.classfile.ConstantDouble;
import randoop.org.apache.bcel.classfile.ConstantFieldref;
import randoop.org.apache.bcel.classfile.ConstantFloat;
import randoop.org.apache.bcel.classfile.ConstantInteger;
import randoop.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import randoop.org.apache.bcel.classfile.ConstantInvokeDynamic;
import randoop.org.apache.bcel.classfile.ConstantLong;
import randoop.org.apache.bcel.classfile.ConstantMethodHandle;
import randoop.org.apache.bcel.classfile.ConstantMethodType;
import randoop.org.apache.bcel.classfile.ConstantMethodref;
import randoop.org.apache.bcel.classfile.ConstantNameAndType;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.ConstantString;
import randoop.org.apache.bcel.classfile.ConstantUtf8;
import randoop.org.apache.bcel.classfile.JavaClass;
import randoop.org.apache.bcel.classfile.Method;
import randoop.org.apache.bcel.generic.ClassGen;
import randoop.org.apache.bcel.generic.ConstantPoolGen;
import randoop.org.apache.bcel.generic.ConstantPushInstruction;
import randoop.org.apache.bcel.generic.Instruction;
import randoop.org.apache.bcel.generic.InstructionList;
import randoop.org.apache.bcel.generic.MethodGen;
import randoop.org.apache.bcel.util.ClassPath;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.reflection.TypeNames;
import randoop.types.JavaTypes;
import randoop.util.MultiMap;

public class ClassFileConstants {
    static @SignatureUnknown byte bb = (byte)23;
    static @SignatureUnknown double d = 35.3;
    static @SignatureUnknown float f = 3.0f;
    static @SignatureUnknown int ii = 20;
    static @SignatureUnknown long ll = 200000L;
    static @SignatureUnknown short s = (short)32000;
    static @SignatureUnknown char c = (char)97;

    public static void main(@SignatureUnknown String @SignatureUnknown [] args) throws @SignatureUnknown IOException {
        for (String classname : args) {
            System.out.println(ClassFileConstants.getConstants(classname));
        }
    }

    public static @SignatureUnknown ConstantSet getConstants(@SignatureUnknown String classname) {
        ConstantSet result = new ConstantSet();
        ClassFileConstants.getConstants(classname, result);
        return result;
    }

    public static @SignatureUnknown ConstantSet getConstants(@SignatureUnknown String classname, @SignatureUnknown ConstantSet result) {
        String resultClassname;
        JavaClass jc;
        try {
            String classfileBase = classname.replace('.', '/');
            InputStream is = ClassPath.SYSTEM_CLASS_PATH.getInputStream(classfileBase, ".class");
            ClassParser cp = new ClassParser(is, classname);
            jc = cp.parse();
        }
        catch (IOException e) {
            throw new Error("IOException while reading '" + classname + "': " + e.getMessage());
        }
        result.classname = resultClassname = jc.getClassName();
        ConstantPool constant_pool = jc.getConstantPool();
        for (Constant c : constant_pool.getConstantPool()) {
            if (c == null || c instanceof ConstantClass || c instanceof ConstantFieldref || c instanceof ConstantInterfaceMethodref || c instanceof ConstantMethodref || c instanceof ConstantNameAndType || c instanceof ConstantMethodHandle || c instanceof ConstantMethodType || c instanceof ConstantInvokeDynamic || c instanceof ConstantUtf8) continue;
            if (c instanceof ConstantString) {
                result.strings.add((String)((ConstantString)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantDouble) {
                result.doubles.add((Double)((ConstantDouble)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantFloat) {
                result.floats.add((Float)((ConstantFloat)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantInteger) {
                result.ints.add((Integer)((ConstantInteger)c).getConstantValue(constant_pool));
                continue;
            }
            if (c instanceof ConstantLong) {
                result.longs.add((Long)((ConstantLong)c).getConstantValue(constant_pool));
                continue;
            }
            throw new RuntimeException("Unrecognized constant of type " + c.getClass() + ": " + c);
        }
        ClassGen gen = new ClassGen(jc);
        ConstantPoolGen pool = gen.getConstantPool();
        for (Method m3 : jc.getMethods()) {
            MethodGen mg = new MethodGen(m3, jc.getClassName(), pool);
            InstructionList il = mg.getInstructionList();
            if (il == null) continue;
            block52: for (Instruction inst : il.getInstructions()) {
                switch (inst.getOpcode()) {
                    case 165: 
                    case 166: {
                        continue block52;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        continue block52;
                    }
                    case 193: {
                        continue block52;
                    }
                    case 89: {
                        continue block52;
                    }
                    case 90: {
                        continue block52;
                    }
                    case 93: {
                        continue block52;
                    }
                    case 92: {
                        continue block52;
                    }
                    case 91: {
                        continue block52;
                    }
                    case 94: {
                        continue block52;
                    }
                    case 87: {
                        continue block52;
                    }
                    case 88: {
                        continue block52;
                    }
                    case 95: {
                        continue block52;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        continue block52;
                    }
                    case 180: {
                        continue block52;
                    }
                    case 181: {
                        continue block52;
                    }
                    case 178: {
                        continue block52;
                    }
                    case 179: {
                        continue block52;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        continue block52;
                    }
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        continue block52;
                    }
                    case 18: 
                    case 19: 
                    case 20: {
                        continue block52;
                    }
                    case 190: {
                        continue block52;
                    }
                    case 14: {
                        result.doubles.add(0.0);
                        continue block52;
                    }
                    case 15: {
                        result.doubles.add(1.0);
                        continue block52;
                    }
                    case 11: {
                        result.floats.add(Float.valueOf(0.0f));
                        continue block52;
                    }
                    case 12: {
                        result.floats.add(Float.valueOf(1.0f));
                        continue block52;
                    }
                    case 13: {
                        result.floats.add(Float.valueOf(2.0f));
                        continue block52;
                    }
                    case 3: {
                        result.ints.add(0);
                        continue block52;
                    }
                    case 4: {
                        result.ints.add(1);
                        continue block52;
                    }
                    case 5: {
                        result.ints.add(2);
                        continue block52;
                    }
                    case 6: {
                        result.ints.add(3);
                        continue block52;
                    }
                    case 7: {
                        result.ints.add(4);
                        continue block52;
                    }
                    case 8: {
                        result.ints.add(5);
                        continue block52;
                    }
                    case 2: {
                        result.ints.add(-1);
                        continue block52;
                    }
                    case 9: {
                        result.longs.add(0L);
                        continue block52;
                    }
                    case 10: {
                        result.longs.add(1L);
                        continue block52;
                    }
                    case 16: 
                    case 17: {
                        ConstantPushInstruction cpi = (ConstantPushInstruction)((Object)inst);
                        result.ints.add((Integer)cpi.getValue());
                        continue block52;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: {
                        continue block52;
                    }
                    case 170: 
                    case 171: {
                        continue block52;
                    }
                    case 188: 
                    case 189: {
                        continue block52;
                    }
                    case 197: {
                        continue block52;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: {
                        continue block52;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        continue block52;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        continue block52;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: {
                        continue block52;
                    }
                    case 191: {
                        continue block52;
                    }
                    case 0: 
                    case 1: 
                    case 25: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 58: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: {
                        continue block52;
                    }
                    default: {
                        throw new Error("instruction " + inst + " unsupported");
                    }
                }
            }
        }
        return result;
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown MultiMap<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>, @SignatureUnknown NonreceiverTerm> toMap(@SignatureUnknown Collection<@SignatureUnknown ConstantSet> constantSets) {
        MultiMap map = new MultiMap();
        for (ConstantSet cs : constantSets) {
            Class<?> clazz;
            try {
                clazz = TypeNames.getTypeForName(cs.classname);
            }
            catch (ClassNotFoundException e) {
                throw new Error("Class " + cs.classname + " not found on the classpath.");
            }
            for (Integer n : cs.ints) {
                try {
                    map.add(clazz, new NonreceiverTerm(JavaTypes.INT_TYPE, n));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Ignoring int constant value: " + e.getMessage());
                }
            }
            for (Long l : cs.longs) {
                try {
                    map.add(clazz, new NonreceiverTerm(JavaTypes.LONG_TYPE, l));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Ignoring long constant value: " + e.getMessage());
                }
            }
            for (Float f : cs.floats) {
                try {
                    map.add(clazz, new NonreceiverTerm(JavaTypes.FLOAT_TYPE, f));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Ignoring float constant value: " + e.getMessage());
                }
            }
            for (Double d : cs.doubles) {
                try {
                    map.add(clazz, new NonreceiverTerm(JavaTypes.DOUBLE_TYPE, d));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Ignoring double constant value: " + e.getMessage());
                }
            }
            for (String string : cs.strings) {
                try {
                    map.add(clazz, new NonreceiverTerm(JavaTypes.STRING_TYPE, string));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Ignoring String constant value: " + e.getMessage());
                }
            }
            for (Class clazz2 : cs.classes) {
                try {
                    map.add(clazz, new NonreceiverTerm(JavaTypes.CLASS_TYPE, clazz2));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Ignoring Class<?> constant value: " + e.getMessage());
                }
            }
        }
        return map;
    }

    public static class ConstantSet {
        public @ClassGetName String classname;
        public @SignatureUnknown Set<@SignatureUnknown Integer> ints = new TreeSet<Integer>();
        public @SignatureUnknown Set<@SignatureUnknown Long> longs = new TreeSet<Long>();
        public @SignatureUnknown Set<@SignatureUnknown Float> floats = new TreeSet<Float>();
        public @SignatureUnknown Set<@SignatureUnknown Double> doubles = new TreeSet<Double>();
        public @SignatureUnknown Set<@SignatureUnknown String> strings = new TreeSet<String>();
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Set<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> classes = new HashSet();

        @SideEffectFree
        public @SignatureUnknown String toString() {
            StringJoiner sb = new StringJoiner(Globals.lineSep);
            sb.add("START CLASSLITERALS for " + this.classname);
            Iterator<Object> iterator = this.ints.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                sb.add("int:" + n);
            }
            iterator = this.longs.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sb.add("long:" + l);
            }
            iterator = this.floats.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                sb.add("float:" + f);
            }
            iterator = this.doubles.iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                sb.add("double:" + d);
            }
            for (String string : this.strings) {
                sb.add("String:\"" + string + "\"");
            }
            for (Class clazz : this.classes) {
                sb.add("Class:" + clazz);
            }
            sb.add("%nEND CLASSLITERALS for " + this.classname);
            return sb.toString();
        }
    }
}

