/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.Set;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.CheckpointingMultiMap;
import randoop.util.ISimpleSet;

public class CheckpointingSet<@SignatureBottom T>
implements ISimpleSet<T> {
    public final @SignatureUnknown CheckpointingMultiMap<T, @SignatureUnknown Boolean> map = new CheckpointingMultiMap();

    @Override
    public void add(T elt) {
        if (elt == null) {
            throw new IllegalArgumentException("arg cannot be null.");
        }
        if (this.contains(elt)) {
            throw new IllegalArgumentException("set already contains elt " + elt);
        }
        this.map.add(elt, true);
    }

    @Override
    public @SignatureUnknown boolean contains(T elt) {
        if (elt == null) {
            throw new IllegalArgumentException("arg cannot be null.");
        }
        return this.map.keySet().contains(elt);
    }

    @Override
    public @SignatureUnknown Set<T> getElements() {
        return this.map.keySet();
    }

    @Override
    public void remove(T elt) {
        if (elt == null) {
            throw new IllegalArgumentException("arg cannot be null.");
        }
        if (!this.contains(elt)) {
            throw new IllegalArgumentException("set does not contain elt " + elt);
        }
        this.map.remove(elt, true);
    }

    @Override
    public @SignatureUnknown int size() {
        return this.map.size();
    }

    public void mark() {
        this.map.mark();
    }

    public void undoToLastMark() {
        this.map.undoToLastMark();
    }

    @Override
    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.map.keySet().toString();
    }
}

