/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.ExplicitTypeVariable;
import randoop.types.JavaTypes;
import randoop.types.ParameterBound;
import randoop.types.ParameterType;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;

public abstract class TypeVariable
extends ParameterType {
    TypeVariable() {
    }

    TypeVariable(@SignatureUnknown ParameterBound lowerBound, @SignatureUnknown ParameterBound upperBound) {
        super(lowerBound, upperBound);
    }

    public static @SignatureUnknown TypeVariable forType(@SignatureUnknown java.lang.reflect.Type type) {
        if (!(type instanceof java.lang.reflect.TypeVariable)) {
            throw new IllegalArgumentException("type must be a type variable, got " + type);
        }
        java.lang.reflect.TypeVariable v = (java.lang.reflect.TypeVariable)type;
        HashSet variableSet = new HashSet();
        variableSet.add(v);
        return new ExplicitTypeVariable(v, ParameterBound.forTypes(variableSet, v.getBounds()));
    }

    @Override
    public @SignatureUnknown ReferenceType substitute(@SignatureUnknown Substitution substitution) {
        ReferenceType type = substitution.get(this);
        if (type != null) {
            return type;
        }
        return this;
    }

    @Override
    public @SignatureUnknown boolean isAssignableFrom(@SignatureUnknown Type sourceType) {
        return false;
    }

    @Override
    public @SignatureUnknown boolean isInstantiationOf(@SignatureUnknown ReferenceType otherType) {
        if (super.isInstantiationOf(otherType)) {
            return true;
        }
        if (otherType.isVariable()) {
            TypeVariable otherVariable = (TypeVariable)otherType;
            Substitution substitution = TypeVariable.getSubstitution(otherVariable, this);
            boolean lowerboundOk = otherVariable.getLowerTypeBound().isLowerBound(this.getLowerTypeBound(), substitution);
            boolean upperboundOk = otherVariable.getUpperTypeBound().isUpperBound(this.getUpperTypeBound(), substitution);
            return lowerboundOk && upperboundOk;
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (otherType.isReferenceType()) {
            Substitution substitution = TypeVariable.getSubstitution(this, (ReferenceType)otherType);
            return this.getUpperTypeBound().isLowerBound(otherType, substitution);
        }
        return false;
    }

    private static @SignatureUnknown Substitution getSubstitution(@SignatureUnknown TypeVariable variable, @SignatureUnknown ReferenceType otherType) {
        return new Substitution(variable, otherType);
    }

    @Override
    public @SignatureUnknown boolean isVariable() {
        return true;
    }

    @SignatureUnknown boolean canBeInstantiatedBy(@SignatureUnknown ReferenceType otherType) {
        TypeVariable checkType;
        ParameterBound boundType;
        Substitution substitution;
        if (this.getLowerTypeBound().isVariable()) {
            substitution = TypeVariable.getSubstitution(this, otherType);
            boundType = this.getLowerTypeBound().substitute(substitution);
            checkType = (TypeVariable)((ReferenceBound)boundType).getBoundType();
            if (!checkType.canBeInstantiatedBy(otherType)) {
                return false;
            }
        } else {
            substitution = TypeVariable.getSubstitution(this, otherType);
            if (!this.getLowerTypeBound().isLowerBound(otherType, substitution)) {
                return false;
            }
        }
        if (this.getUpperTypeBound().isVariable()) {
            substitution = TypeVariable.getSubstitution(this, otherType);
            boundType = this.getUpperTypeBound().substitute(substitution);
            checkType = (TypeVariable)((ReferenceBound)boundType).getBoundType();
            if (!checkType.canBeInstantiatedBy(otherType)) {
                return false;
            }
        } else {
            substitution = TypeVariable.getSubstitution(this, otherType);
            if (!this.getUpperTypeBound().isUpperBound(otherType, substitution)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        LinkedHashSet<TypeVariable> parameters = new LinkedHashSet<TypeVariable>(super.getTypeParameters());
        parameters.add(this);
        return new ArrayList<TypeVariable>(parameters);
    }

    public abstract @SignatureUnknown TypeVariable createCopyWithBounds(@SignatureUnknown ParameterBound var1, @SignatureUnknown ParameterBound var2);

    @Override
    public @SignatureUnknown Type getRawtype() {
        return JavaTypes.OBJECT_TYPE;
    }
}

