/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.UtilPlume;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

public class TypeTuple
implements Iterable<Type>,
Comparable<TypeTuple> {
    private final @SignatureUnknown ArrayList<@SignatureUnknown Type> list;

    public TypeTuple(@SignatureUnknown List<@SignatureUnknown Type> list) {
        this.list = new ArrayList<Type>(list);
    }

    public TypeTuple() {
        this(new ArrayList<Type>());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeTuple)) {
            return false;
        }
        TypeTuple tuple = (TypeTuple)obj;
        return this.list.equals(tuple.list);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.list);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "(" + UtilPlume.join((CharSequence)", ", this.list) + ")";
    }

    public @SignatureUnknown TypeTuple substitute(@SignatureUnknown Substitution substitution) {
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Type type : this.list) {
            Type newType = type.substitute(substitution);
            if (newType != null) {
                typeList.add(newType);
                continue;
            }
            typeList.add(type);
        }
        return new TypeTuple(typeList);
    }

    public @SignatureUnknown TypeTuple applyCaptureConversion() {
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Type type : this.list) {
            typeList.add(type.applyCaptureConversion());
        }
        return new TypeTuple(typeList);
    }

    public @SignatureUnknown Type get(@SignatureUnknown int i) {
        return this.list.get(i);
    }

    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        LinkedHashSet<TypeVariable> paramSet = new LinkedHashSet<TypeVariable>();
        for (Type type : this.list) {
            if (!type.isReferenceType()) continue;
            paramSet.addAll(((ReferenceType)type).getTypeParameters());
        }
        return new ArrayList<TypeVariable>(paramSet);
    }

    public @SignatureUnknown boolean hasWildcard() {
        for (Type type : this.list) {
            if (!type.isParameterized() || !((ParameterizedType)type).hasWildcard()) continue;
            return true;
        }
        return false;
    }

    public @SignatureUnknown boolean hasCaptureVariable() {
        for (Type type : this.list) {
            if (!type.isParameterized() || !((ParameterizedType)type).hasCaptureVariable()) continue;
            return true;
        }
        return false;
    }

    public @SignatureUnknown boolean isEmpty() {
        return this.list.isEmpty();
    }

    public @SignatureUnknown int size() {
        return this.list.size();
    }

    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        for (Type type : this.list) {
            if (!type.isGeneric(ignoreWildcards)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @SignatureUnknown Iterator<@SignatureUnknown Type> iterator() {
        return new TypeIterator(this.list.iterator());
    }

    @Override
    @Pure
    public @SignatureUnknown int compareTo(@SignatureUnknown TypeTuple tuple) {
        if (this.size() < tuple.size()) {
            return -1;
        }
        if (this.size() > tuple.size()) {
            return 1;
        }
        int result = 0;
        for (int i = 0; i < this.size() && result == 0; ++i) {
            result = this.list.get(i).compareTo(tuple.list.get(i));
        }
        return result;
    }

    private static class TypeIterator
    implements Iterator<Type> {
        private @SignatureUnknown Iterator<@SignatureUnknown Type> iterator;

        public TypeIterator(@SignatureUnknown Iterator<@SignatureUnknown Type> iterator) {
            this.iterator = iterator;
        }

        @Override
        @Pure
        public @SignatureUnknown boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public @SignatureUnknown Type next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

