/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.Array;
import java.lang.reflect.WildcardType;
import java.util.StringTokenizer;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.FqBinaryName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.reflection.Signatures;
import randoop.types.ArrayType;
import randoop.types.JavaTypes;
import randoop.types.PrimitiveType;
import randoop.types.PrimitiveTypes;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.VoidType;

public abstract class Type
implements Comparable<Type> {
    public static @SignatureUnknown Type forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> classType) {
        if (classType.equals(Void.TYPE)) {
            return VoidType.getVoidType();
        }
        if (classType.isPrimitive()) {
            return PrimitiveType.forClass(classType);
        }
        return ReferenceType.forClass(classType);
    }

    public static @SignatureUnknown Type forName(@ClassGetName String typeName) throws @SignatureUnknown ClassNotFoundException {
        Class<?> c = PrimitiveTypes.classForName(typeName);
        if (c == null) {
            c = Class.forName(typeName);
        }
        return Type.forClass(c);
    }

    public static @SignatureUnknown Type getTypeforFullyQualifiedName(@FqBinaryName String fullyQualifiedName) throws @SignatureUnknown ClassNotFoundException {
        Class<?> className = Type.forFullyQualifiedName(fullyQualifiedName);
        return className.isArray() ? ArrayType.forClass(className) : Type.forClass(className);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> forFullyQualifiedName(@FqBinaryName String fullyQualifiedName) throws @SignatureUnknown ClassNotFoundException {
        @ClassGetName String baseTypeName = Signatures.getArrayElementType(fullyQualifiedName);
        Class<?> baseType = Type.forFullyQualifiedNameNonArray(baseTypeName);
        int arrayDimension = Type.numDimensions(fullyQualifiedName);
        if (arrayDimension > 0) {
            int[] dimensions = new int[arrayDimension];
            return Array.newInstance(baseType, dimensions).getClass();
        }
        return baseType;
    }

    private static @SignatureUnknown int numDimensions(@FqBinaryName String typeName) {
        return new StringTokenizer(typeName, "[").countTokens() - 1;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> forFullyQualifiedNameNonArray(@ClassGetName String fullyQualifiedName) throws @SignatureUnknown ClassNotFoundException {
        Class<?> c = PrimitiveTypes.classForName(fullyQualifiedName);
        if (c != null) {
            return c;
        }
        try {
            return Class.forName(fullyQualifiedName);
        }
        catch (ClassNotFoundException e) {
            while (true) {
                String innerName;
                int pos;
                if ((pos = fullyQualifiedName.lastIndexOf(46)) == -1) {
                    throw e;
                }
                fullyQualifiedName = innerName = fullyQualifiedName.substring(0, pos) + "$" + fullyQualifiedName.substring(pos + 1);
                try {
                    return Class.forName(fullyQualifiedName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                break;
            }
        }
    }

    public static @SignatureUnknown Type forValue(@SignatureUnknown Object value) {
        return Type.forClass(value.getClass());
    }

    public static @SignatureUnknown Type forType(@SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof WildcardType) {
            throw new IllegalArgumentException("Cannot construct type for wildcard " + type);
        }
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            return Type.forClass((Class)type);
        }
        return ReferenceType.forType(type);
    }

    public abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass();

    public abstract @SignatureUnknown String getFqName();

    public abstract @SignatureUnknown String getBinaryName();

    public abstract @SignatureUnknown String getSimpleName();

    public @SignatureUnknown String getCanonicalName() {
        return this.getRuntimeClass().getCanonicalName();
    }

    public @SignatureUnknown String getUnqualifiedBinaryName() {
        return this.getSimpleName();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.getBinaryName();
    }

    public @SignatureUnknown Type getRawtype() {
        return this;
    }

    public @SignatureUnknown boolean runtimeClassIs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        return this.getRuntimeClass().equals(c);
    }

    public @SignatureUnknown boolean isArray() {
        return false;
    }

    public @SignatureUnknown boolean isBoxedPrimitive() {
        return false;
    }

    public @SignatureUnknown boolean isClass() {
        return this.equals(JavaTypes.CLASS_TYPE);
    }

    public @SignatureUnknown boolean isEnum() {
        return false;
    }

    public final @SignatureUnknown boolean isGeneric() {
        return this.isGeneric(false);
    }

    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return false;
    }

    public @SignatureUnknown boolean isInterface() {
        return false;
    }

    public @SignatureUnknown boolean isObject() {
        return this.equals(JavaTypes.OBJECT_TYPE);
    }

    public @SignatureUnknown boolean isString() {
        return this.equals(JavaTypes.STRING_TYPE);
    }

    public @SignatureUnknown boolean isVoid() {
        return this.equals(JavaTypes.VOID_TYPE);
    }

    public @SignatureUnknown boolean isParameterized() {
        return false;
    }

    public @SignatureUnknown boolean hasWildcard() {
        return false;
    }

    public @SignatureUnknown boolean hasCaptureVariable() {
        return false;
    }

    public @SignatureUnknown boolean isPrimitive() {
        return false;
    }

    public @SignatureUnknown boolean isNonreceiverType() {
        return this.isPrimitive() || this.isBoxedPrimitive() || this.getRuntimeClass() == String.class || this.getRuntimeClass() == Class.class;
    }

    public @SignatureUnknown boolean isRawtype() {
        return false;
    }

    public @SignatureUnknown boolean isReferenceType() {
        return false;
    }

    public @SignatureUnknown boolean isVariable() {
        return false;
    }

    public @SignatureUnknown Type substitute(@SignatureUnknown Substitution substitution) {
        return this;
    }

    public @SignatureUnknown Type applyCaptureConversion() {
        return this;
    }

    public @SignatureUnknown boolean isAssignableFrom(@SignatureUnknown Type sourceType) {
        if (sourceType.isVoid()) {
            return false;
        }
        return this.equals(sourceType);
    }

    public <T> @SignatureUnknown boolean isAssignableFromTypeOf(T value) {
        if (value == null) {
            return !this.isPrimitive();
        }
        Type type = Type.forClass(value.getClass());
        return this.isAssignableFrom(type);
    }

    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        return this.equals(otherType);
    }

    public @SignatureUnknown boolean isClassOrInterfaceType() {
        return false;
    }

    @Override
    @Pure
    public @SignatureUnknown int compareTo(@SignatureUnknown Type type) {
        String name1 = this.getCanonicalName();
        String name2 = type.getCanonicalName();
        if (name1 != null && name2 != null) {
            return this.getCanonicalName().compareTo(type.getCanonicalName());
        }
        return this.getRuntimeClass().getName().compareTo(type.getRuntimeClass().getName());
    }
}

