/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class PrimitiveTypes {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Map<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>, @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> boxedToPrimitive = new LinkedHashMap();
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Map<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>, @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> primitiveToBoxed;
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> nameToClass;
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Map<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>, @SignatureUnknown Set<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>>> wideningTable;

    private PrimitiveTypes() {
        throw new IllegalStateException("no instances");
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> classForName(@SignatureUnknown String typeName) {
        return nameToClass.get(typeName);
    }

    static @SignatureUnknown boolean isAssignable(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> target, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> source) {
        if (!target.isPrimitive() || !source.isPrimitive()) {
            throw new IllegalArgumentException("types must be primitive");
        }
        return source.equals(target) || PrimitiveTypes.isSubtype(source, target);
    }

    public static @SignatureUnknown boolean isBoxedPrimitive(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        return boxedToPrimitive.containsKey(c);
    }

    static @SignatureUnknown boolean isSubtype(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> first, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> second) {
        if (!first.isPrimitive() && !second.isPrimitive()) {
            throw new IllegalArgumentException("types must be primitive");
        }
        Set<Class<?>> superTypes = wideningTable.get(first);
        return superTypes.contains(second);
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> toBoxedType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> cls) {
        return primitiveToBoxed.get(cls);
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> toUnboxedType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        return boxedToPrimitive.get(c);
    }

    static {
        boxedToPrimitive.put(Integer.class, Integer.TYPE);
        boxedToPrimitive.put(Boolean.class, Boolean.TYPE);
        boxedToPrimitive.put(Float.class, Float.TYPE);
        boxedToPrimitive.put(Character.class, Character.TYPE);
        boxedToPrimitive.put(Double.class, Double.TYPE);
        boxedToPrimitive.put(Long.class, Long.TYPE);
        boxedToPrimitive.put(Short.class, Short.TYPE);
        boxedToPrimitive.put(Byte.class, Byte.TYPE);
        primitiveToBoxed = new LinkedHashMap(8);
        primitiveToBoxed.put(Boolean.TYPE, Boolean.class);
        primitiveToBoxed.put(Byte.TYPE, Byte.class);
        primitiveToBoxed.put(Character.TYPE, Character.class);
        primitiveToBoxed.put(Double.TYPE, Double.class);
        primitiveToBoxed.put(Float.TYPE, Float.class);
        primitiveToBoxed.put(Integer.TYPE, Integer.class);
        primitiveToBoxed.put(Long.TYPE, Long.class);
        primitiveToBoxed.put(Short.TYPE, Short.class);
        nameToClass = new LinkedHashMap();
        nameToClass.put("void", Void.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        wideningTable = new HashMap();
        wideningTable.put(Boolean.TYPE, new HashSet());
        wideningTable.put(Double.TYPE, new HashSet());
        HashSet<Class<Number>> s2 = new HashSet<Class<Number>>();
        s2.add(Double.TYPE);
        wideningTable.put(Float.TYPE, new HashSet(s2));
        s2.add(Float.TYPE);
        wideningTable.put(Long.TYPE, new HashSet(s2));
        s2.add(Long.TYPE);
        wideningTable.put(Integer.TYPE, new HashSet(s2));
        s2.add(Integer.TYPE);
        wideningTable.put(Character.TYPE, new HashSet(s2));
        wideningTable.put(Short.TYPE, new HashSet(s2));
        s2.add(Short.TYPE);
        wideningTable.put(Byte.TYPE, new HashSet(s2));
    }
}

