/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.HashMap;
import java.util.Map;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.types.NonParameterizedType;
import randoop.types.PrimitiveTypes;
import randoop.types.Type;

public class PrimitiveType
extends Type {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeClass;
    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Map<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>, @SignatureUnknown PrimitiveType> cache = new HashMap();

    public static @SignatureUnknown PrimitiveType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeClass) {
        PrimitiveType cached = cache.get(runtimeClass);
        if (cached == null) {
            cached = new PrimitiveType(runtimeClass);
            cache.put(runtimeClass, cached);
        }
        return cached;
    }

    private PrimitiveType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeClass) {
        assert (runtimeClass.isPrimitive()) : "must be initialized with primitive type, got " + runtimeClass.getName();
        assert (!runtimeClass.equals(Void.TYPE)) : "void should be represented by VoidType";
        this.runtimeClass = runtimeClass;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PrimitiveType)) {
            return false;
        }
        PrimitiveType t = (PrimitiveType)obj;
        return this.runtimeClass.equals(t.runtimeClass);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return this.runtimeClass.hashCode();
    }

    @Override
    public @SignatureUnknown String getFqName() {
        return this.runtimeClass.getCanonicalName();
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        return this.runtimeClass.getCanonicalName();
    }

    @Override
    public @SignatureUnknown String getSimpleName() {
        return this.runtimeClass.getSimpleName();
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.runtimeClass;
    }

    @Override
    public @SignatureUnknown boolean isAssignableFrom(@SignatureUnknown Type sourceType) {
        if (super.isAssignableFrom(sourceType)) {
            return true;
        }
        if (sourceType.isPrimitive()) {
            return PrimitiveTypes.isAssignable(this.runtimeClass, sourceType.getRuntimeClass());
        }
        if (sourceType.isBoxedPrimitive()) {
            PrimitiveType primitiveSourceType = ((NonParameterizedType)sourceType).toPrimitive();
            return this.isAssignableFrom(primitiveSourceType);
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isPrimitive() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isNonreceiverType() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        return otherType.isPrimitive() && PrimitiveTypes.isSubtype(this.getRuntimeClass(), otherType.getRuntimeClass());
    }

    public @SignatureUnknown NonParameterizedType toBoxedPrimitive() {
        return NonParameterizedType.forClass(PrimitiveTypes.toBoxedType(this.getRuntimeClass()));
    }
}

