/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.Substitution;
import randoop.types.TypeArgument;

public abstract class ParameterizedType
extends ClassOrInterfaceType {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Map<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>, @SignatureUnknown GenericClassType> cache = new HashMap();

    public static @SignatureUnknown GenericClassType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> typeClass) {
        if (typeClass.getTypeParameters().length == 0) {
            throw new IllegalArgumentException("class must be a generic type, have " + typeClass.getName());
        }
        GenericClassType cached = cache.get(typeClass);
        if (cached == null) {
            cached = new GenericClassType(typeClass);
            cache.put(typeClass, cached);
        }
        return cached;
    }

    public static @SignatureUnknown ParameterizedType forType(@SignatureUnknown Type type) {
        if (!(type instanceof java.lang.reflect.ParameterizedType)) {
            throw new IllegalArgumentException("type must be java.lang.reflect.ParameterizedType");
        }
        java.lang.reflect.ParameterizedType t = (java.lang.reflect.ParameterizedType)type;
        Type rawType = t.getRawType();
        assert (rawType instanceof Class) : "rawtype not an instance of Class<?> type ";
        ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>();
        for (Type argType : t.getActualTypeArguments()) {
            TypeArgument argument = TypeArgument.forType(argType);
            typeArguments.add(argument);
        }
        GenericClassType genericClass = ParameterizedType.forClass((Class)rawType);
        return new InstantiatedType(genericClass, typeArguments);
    }

    @Override
    public abstract @SignatureUnknown ParameterizedType substitute(@SignatureUnknown Substitution var1);

    public abstract @SignatureUnknown GenericClassType getGenericClassType();

    @Override
    public @SignatureUnknown String getFqName() {
        return super.getFqName() + "<" + this.getTypeArguments().stream().map(TypeArgument::getFqName).collect(Collectors.joining(",")) + ">";
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        return super.getBinaryName() + "<" + this.getTypeArguments().stream().map(TypeArgument::getBinaryName).collect(Collectors.joining(",")) + ">";
    }

    @Override
    public @SignatureUnknown String getUnqualifiedBinaryName() {
        return super.getUnqualifiedBinaryName() + "<" + this.getTypeArguments().stream().map(TypeArgument::getBinaryName).collect(Collectors.joining(",")) + ">";
    }
}

