/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.types.EagerReferenceBound;
import randoop.types.JavaTypes;
import randoop.types.ParameterBound;
import randoop.types.ReferenceType;
import randoop.types.TypeVariable;

public abstract class ParameterType
extends ReferenceType {
    private @SignatureUnknown ParameterBound lowerBound;
    private @SignatureUnknown ParameterBound upperBound;

    ParameterType() {
        this.lowerBound = new EagerReferenceBound(JavaTypes.NULL_TYPE);
        this.upperBound = new EagerReferenceBound(JavaTypes.OBJECT_TYPE);
    }

    ParameterType(@SignatureUnknown ParameterBound lowerBound, @SignatureUnknown ParameterBound upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParameterType)) {
            return false;
        }
        ParameterType other = (ParameterType)object;
        return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    @Override
    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "ParameterType [ " + this.lowerBound + ", " + this.upperBound + " ]";
    }

    @Override
    public @SignatureUnknown String getCanonicalName() {
        return this.getFqName();
    }

    public @SignatureUnknown ParameterBound getLowerTypeBound() {
        return this.lowerBound;
    }

    public @SignatureUnknown ParameterBound getUpperTypeBound() {
        return this.upperBound;
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        LinkedHashSet<TypeVariable> parameters = new LinkedHashSet<TypeVariable>();
        parameters.addAll(this.lowerBound.getTypeParameters());
        parameters.addAll(this.upperBound.getTypeParameters());
        return new ArrayList<TypeVariable>(parameters);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return null;
    }

    void setUpperBound(@SignatureUnknown ParameterBound upperBound) {
        this.upperBound = upperBound;
    }

    void setLowerBound(@SignatureUnknown ParameterBound lowerBound) {
        this.lowerBound = lowerBound;
    }

    @Override
    public @SignatureUnknown boolean hasWildcard() {
        return this.getLowerTypeBound().hasWildcard() || this.getUpperTypeBound().hasWildcard();
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return this.getLowerTypeBound().hasCaptureVariable() || this.getUpperTypeBound().hasCaptureVariable();
    }

    public @SignatureUnknown boolean hasGenericBound() {
        return this.getUpperTypeBound().isGeneric() || this.getLowerTypeBound().isGeneric();
    }
}

