/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.types.EagerReferenceBound;
import randoop.types.InstantiatedType;
import randoop.types.ParameterBound;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

class LazyReferenceBound
extends ReferenceBound {
    LazyReferenceBound(@SignatureUnknown ReferenceType boundType) {
        super(boundType);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.toString());
    }

    @Override
    public @SignatureUnknown ReferenceBound substitute(@SignatureUnknown Substitution substitution) {
        if (substitution.isEmpty()) {
            return this;
        }
        for (TypeVariable parameter : this.getTypeParameters()) {
            if (substitution.get(parameter) != null) continue;
            return this;
        }
        ReferenceType referenceType = this.getBoundType().substitute(substitution);
        if (referenceType.equals(this.getBoundType())) {
            return this;
        }
        if (this.getBoundType().isVariable()) {
            if (referenceType.isVariable()) {
                return new LazyReferenceBound(referenceType);
            }
            return new EagerReferenceBound(referenceType);
        }
        if (this.getBoundType().isParameterized()) {
            return new EagerReferenceBound(referenceType);
        }
        return this;
    }

    @Override
    public @SignatureUnknown ReferenceBound applyCaptureConversion() {
        return null;
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        ArrayList<TypeVariable> parameters = new ArrayList<TypeVariable>();
        if (this.getBoundType().isVariable()) {
            parameters.add((TypeVariable)this.getBoundType());
        } else if (this.getBoundType().isParameterized()) {
            for (ReferenceType argType : ((InstantiatedType)this.getBoundType()).getReferenceArguments()) {
                if (!argType.isVariable()) continue;
                parameters.add((TypeVariable)argType);
            }
        }
        return parameters;
    }

    @Override
    public @SignatureUnknown boolean isLowerBound(@SignatureUnknown Type argType, @SignatureUnknown Substitution substitution) {
        ReferenceBound b = this.substitute(substitution);
        return !this.equals(b) && b.isLowerBound(argType, substitution);
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown ParameterBound boundType) {
        assert (false) : "subtype not implemented for LazyReferenceBound";
        return false;
    }

    @Override
    public @SignatureUnknown boolean isUpperBound(@SignatureUnknown Type argType, @SignatureUnknown Substitution substitution) {
        ReferenceBound b = this.substitute(substitution);
        return !this.equals(b) && b.isUpperBound(argType, substitution);
    }

    @Override
    @SignatureUnknown boolean isUpperBound(@SignatureUnknown ParameterBound bound, @SignatureUnknown Substitution substitution) {
        assert (false) : "isUpperBound(ParameterBound, Substitution) not implemented";
        return false;
    }
}

