/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.types.CaptureTypeVariable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.NonParameterizedType;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceArgument;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;
import randoop.types.WildcardArgument;

public class InstantiatedType
extends ParameterizedType {
    private final @SignatureUnknown GenericClassType genericType;
    private final @SignatureUnknown List<@SignatureUnknown TypeArgument> argumentList;

    InstantiatedType(@SignatureUnknown GenericClassType genericType, @SignatureUnknown List<@SignatureUnknown TypeArgument> argumentList) {
        if (genericType == null) {
            throw new IllegalArgumentException("instantiated type must be non-null");
        }
        this.genericType = genericType;
        this.argumentList = argumentList;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InstantiatedType)) {
            return false;
        }
        InstantiatedType other = (InstantiatedType)obj;
        return this.genericType.equals(other.getGenericClassType()) && this.argumentList.equals(other.argumentList);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.genericType, this.argumentList);
    }

    @Override
    public @SignatureUnknown InstantiatedType substitute(@SignatureUnknown Substitution substitution) {
        ArrayList<TypeArgument> argumentList = new ArrayList<TypeArgument>();
        for (TypeArgument argument : this.argumentList) {
            argumentList.add(argument.substitute(substitution));
        }
        return (InstantiatedType)this.substitute(substitution, new InstantiatedType(this.genericType, argumentList));
    }

    @Override
    public @SignatureUnknown InstantiatedType applyCaptureConversion() {
        if (!this.hasWildcard()) {
            return this;
        }
        ArrayList<ReferenceType> convertedTypeList = new ArrayList<ReferenceType>();
        for (TypeArgument argument : this.argumentList) {
            Object convertedArgument;
            if (argument.isWildcard()) {
                convertedArgument = ((WildcardArgument)argument).applyCaptureConversion();
                convertedTypeList.add(new CaptureTypeVariable((WildcardArgument)convertedArgument));
                continue;
            }
            convertedArgument = ((ReferenceArgument)argument).getReferenceType().applyCaptureConversion();
            convertedTypeList.add((ReferenceType)convertedArgument);
        }
        Substitution substitution = new Substitution(this.genericType.getTypeParameters(), convertedTypeList);
        for (int i = 0; i < convertedTypeList.size(); ++i) {
            if (!((ReferenceType)convertedTypeList.get(i)).isCaptureVariable()) continue;
            CaptureTypeVariable captureVariable = (CaptureTypeVariable)convertedTypeList.get(i);
            captureVariable.convert(this.genericType.getTypeParameters().get(i), substitution);
        }
        ArrayList<TypeArgument> convertedArgumentList = new ArrayList<TypeArgument>();
        for (ReferenceType type : convertedTypeList) {
            convertedArgumentList.add(TypeArgument.forType(type));
        }
        return (InstantiatedType)this.applyCaptureConversion(new InstantiatedType(this.genericType, convertedArgumentList));
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getInterfaces() {
        ArrayList<ClassOrInterfaceType> interfaces = new ArrayList<ClassOrInterfaceType>();
        Substitution substitution = new Substitution(this.genericType.getTypeParameters(), this.getReferenceArguments());
        for (ClassOrInterfaceType type : this.genericType.getInterfaces(substitution)) {
            interfaces.add(type);
        }
        return interfaces;
    }

    @Override
    public @SignatureUnknown GenericClassType getGenericClassType() {
        return this.genericType.getGenericClassType();
    }

    @Override
    public @SignatureUnknown InstantiatedType getMatchingSupertype(@SignatureUnknown GenericClassType goalType) {
        if (this.isInstantiationOf(goalType)) {
            return this;
        }
        return super.getMatchingSupertype(goalType);
    }

    @SignatureUnknown List<@SignatureUnknown ReferenceType> getReferenceArguments() {
        ArrayList<ReferenceType> referenceArgList = new ArrayList<ReferenceType>();
        for (TypeArgument argument : this.argumentList) {
            if (!argument.isWildcard()) {
                referenceArgList.add(((ReferenceArgument)argument).getReferenceType());
                continue;
            }
            referenceArgList.add(((WildcardArgument)argument).getWildcardType());
        }
        return referenceArgList;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.genericType.getRuntimeClass();
    }

    @Override
    public @SignatureUnknown ClassOrInterfaceType getSuperclass() {
        Substitution substitution = new Substitution(this.genericType.getTypeParameters(), this.getReferenceArguments());
        return this.getGenericClassType().getSuperclass(substitution);
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeArgument> getTypeArguments() {
        return this.argumentList;
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        LinkedHashSet<TypeVariable> paramSet = new LinkedHashSet<TypeVariable>(super.getTypeParameters());
        for (TypeArgument argument : this.argumentList) {
            List<TypeVariable> params = argument.getTypeParameters();
            paramSet.addAll(params);
        }
        return new ArrayList<TypeVariable>(paramSet);
    }

    public @SignatureUnknown Substitution getTypeSubstitution() {
        ArrayList<ReferenceType> arguments = new ArrayList<ReferenceType>();
        for (TypeArgument arg : this.getTypeArguments()) {
            if (arg.isWildcard()) continue;
            arguments.add(((ReferenceArgument)arg).getReferenceType());
        }
        Substitution substitution = null;
        if (arguments.size() == this.getTypeArguments().size()) {
            substitution = new Substitution(this.genericType.getTypeParameters(), arguments);
        }
        return substitution;
    }

    @Override
    public @SignatureUnknown boolean hasWildcard() {
        for (TypeArgument argument : this.argumentList) {
            if (!argument.hasWildcard()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        for (TypeArgument argument : this.argumentList) {
            if (!argument.hasCaptureVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isAbstract() {
        return this.genericType.isAbstract();
    }

    @Override
    public @SignatureUnknown boolean isAssignableFrom(@SignatureUnknown Type otherType) {
        if (super.isAssignableFrom(otherType)) {
            return true;
        }
        return otherType.isRawtype() && otherType.runtimeClassIs(this.getRuntimeClass());
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        if (super.isGeneric(ignoreWildcards)) {
            return true;
        }
        for (TypeArgument argument : this.argumentList) {
            if (!argument.isGeneric(ignoreWildcards)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isInstantiationOf(@SignatureUnknown ReferenceType otherType) {
        if (super.isInstantiationOf(otherType) && !(otherType instanceof InstantiatedType)) {
            return true;
        }
        if (otherType instanceof InstantiatedType) {
            InstantiatedType otherInstType = (InstantiatedType)otherType;
            if (!this.getGenericClassType().equals(otherInstType.getGenericClassType())) {
                return false;
            }
            for (int i = 0; i < this.argumentList.size(); ++i) {
                TypeArgument otherTypeArg;
                TypeArgument thisTypeArg = this.argumentList.get(i);
                if (thisTypeArg.isInstantiationOfTypeArgument(otherTypeArg = otherInstType.argumentList.get(i))) continue;
                return false;
            }
            return true;
        }
        if (otherType instanceof GenericClassType) {
            GenericClassType otherGenClass = (GenericClassType)otherType;
            return this.getGenericClassType().equals(otherGenClass);
        }
        return super.isInstantiationOf(otherType);
    }

    @Override
    public @SignatureUnknown Substitution getInstantiatingSubstitution(@SignatureUnknown ReferenceType goalType) {
        Substitution superResult = ReferenceType.getInstantiatingSubstitutionforTypeVariable(this, goalType);
        if (superResult != null) {
            return superResult;
        }
        assert (goalType.isGeneric());
        Substitution substitution = super.getInstantiatingSubstitution(goalType);
        if (goalType instanceof InstantiatedType) {
            InstantiatedType otherInstType = (InstantiatedType)goalType;
            if (this.getGenericClassType().equals(otherInstType.getGenericClassType())) {
                for (int i = 0; i < this.argumentList.size(); ++i) {
                    TypeArgument otherTArg;
                    TypeArgument thisTArg = this.argumentList.get(i);
                    Substitution subst = thisTArg.getInstantiatingSubstitution(otherTArg = otherInstType.argumentList.get(i));
                    if (subst == null) {
                        return null;
                    }
                    substitution = substitution.extend(subst);
                }
                return substitution;
            }
            return null;
        }
        if (goalType instanceof GenericClassType) {
            return substitution;
        }
        return null;
    }

    @Override
    public @SignatureUnknown boolean isInterface() {
        return this.genericType.isInterface();
    }

    @Override
    public @SignatureUnknown boolean isParameterized() {
        return true;
    }

    public @SignatureUnknown boolean isRecursiveType() {
        if (this.argumentList.size() > 1 || this.argumentList.get(0).hasWildcard()) {
            return false;
        }
        ReferenceType argType = ((ReferenceArgument)this.argumentList.get(0)).getReferenceType();
        return argType.isSubtypeOf(this);
    }

    @Override
    public @SignatureUnknown boolean isStatic() {
        return this.genericType.isStatic();
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        if (otherType.isParameterized()) {
            InstantiatedType otherInstandiatedType;
            InstantiatedType superType;
            if (otherType.runtimeClassIs(this.getRuntimeClass())) {
                int i;
                InstantiatedType otherInstantiatedType = (InstantiatedType)otherType;
                List<TypeArgument> otherTypeArguments = otherInstantiatedType.getTypeArguments();
                List<TypeArgument> thisTypeArguments = this.getTypeArguments();
                assert (otherTypeArguments.size() == thisTypeArguments.size());
                for (i = 0; i < thisTypeArguments.size() && otherTypeArguments.get(i).contains(thisTypeArguments.get(i)); ++i) {
                }
                if (i == thisTypeArguments.size()) {
                    return true;
                }
            }
            if ((superType = this.getMatchingSupertype((otherInstandiatedType = (InstantiatedType)otherType).getGenericClassType())) != null && superType.equals(otherType)) {
                return true;
            }
        }
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (this.hasWildcard()) {
            return this.applyCaptureConversion().isSubtypeOf(otherType);
        }
        return this.getRawtype().isSubtypeOf(otherType);
    }

    @Override
    public @SignatureUnknown NonParameterizedType getRawtype() {
        return this.genericType.getRawtype();
    }
}

