/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.List;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.ClassOrInterfaceType;
import randoop.types.InstantiatedType;
import randoop.types.JavaTypes;
import randoop.types.LazyParameterBound;
import randoop.types.ParameterBound;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

class EagerReferenceBound
extends ReferenceBound {
    EagerReferenceBound(@SignatureUnknown ReferenceType boundType) {
        super(boundType);
    }

    @Override
    public @SignatureUnknown EagerReferenceBound substitute(@SignatureUnknown Substitution substitution) {
        ReferenceType referenceType = this.getBoundType().substitute(substitution);
        if (referenceType.equals(this.getBoundType())) {
            return this;
        }
        return new EagerReferenceBound(referenceType);
    }

    @Override
    public @SignatureUnknown EagerReferenceBound applyCaptureConversion() {
        ReferenceType referenceType = this.getBoundType().applyCaptureConversion();
        if (referenceType.equals(this.getBoundType())) {
            return this;
        }
        return new EagerReferenceBound(referenceType);
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        return this.getBoundType().getTypeParameters();
    }

    @Override
    public @SignatureUnknown boolean isLowerBound(@SignatureUnknown Type argType, @SignatureUnknown Substitution subst) {
        ReferenceType boundType = this.getBoundType().substitute(subst);
        if (boundType.equals(JavaTypes.NULL_TYPE)) {
            return true;
        }
        if (boundType.isVariable()) {
            return ((TypeVariable)boundType).getLowerTypeBound().isLowerBound(argType, subst);
        }
        if (argType.isParameterized()) {
            if (!(boundType instanceof ClassOrInterfaceType)) {
                return false;
            }
            InstantiatedType argClassType = (InstantiatedType)argType.applyCaptureConversion();
            InstantiatedType boundSuperType = ((ClassOrInterfaceType)boundType).getMatchingSupertype(argClassType.getGenericClassType());
            if (boundSuperType == null) {
                return false;
            }
            boundSuperType = boundSuperType.applyCaptureConversion();
            return boundSuperType.isInstantiationOf(argClassType);
        }
        return boundType.isSubtypeOf(argType);
    }

    @Override
    @SignatureUnknown boolean isLowerBound(@SignatureUnknown ParameterBound bound, @SignatureUnknown Substitution substitution) {
        assert (bound instanceof EagerReferenceBound) : "only handling reference bounds";
        return this.isLowerBound(((EagerReferenceBound)bound).getBoundType(), substitution);
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown ParameterBound bound) {
        if (bound instanceof EagerReferenceBound) {
            return this.getBoundType().isSubtypeOf(((EagerReferenceBound)bound).getBoundType());
        }
        assert (false) : "not handling EagerReferenceBound subtype of other bound type";
        return false;
    }

    @Override
    public @SignatureUnknown boolean isUpperBound(@SignatureUnknown Type argType, @SignatureUnknown Substitution subst) {
        ReferenceType boundType = this.getBoundType().substitute(subst);
        if (boundType.equals(JavaTypes.OBJECT_TYPE)) {
            return true;
        }
        if (boundType.isVariable()) {
            return ((TypeVariable)boundType).getUpperTypeBound().isUpperBound(argType, subst);
        }
        if (boundType.isParameterized()) {
            InstantiatedType boundClassType;
            if (!(argType instanceof ClassOrInterfaceType)) {
                return false;
            }
            try {
                boundClassType = (InstantiatedType)boundType.applyCaptureConversion();
            }
            catch (LazyParameterBound.LazyBoundException e) {
                return false;
            }
            InstantiatedType argSuperType = ((ClassOrInterfaceType)argType).getMatchingSupertype(boundClassType.getGenericClassType());
            if (argSuperType == null) {
                return false;
            }
            argSuperType = argSuperType.applyCaptureConversion();
            return argSuperType.isInstantiationOf(boundClassType);
        }
        return argType.isSubtypeOf(boundType);
    }

    @Override
    @SignatureUnknown boolean isUpperBound(@SignatureUnknown ParameterBound bound, @SignatureUnknown Substitution substitution) {
        return this.isUpperBound(this.getBoundType(), substitution);
    }
}

