/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.contract.EnumValue;
import randoop.contract.IsNotNull;
import randoop.contract.IsNull;
import randoop.contract.ObserverEqValue;
import randoop.contract.PrimValue;
import randoop.operation.TypedClassOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.reflection.OmitMethodsPredicate;
import randoop.reflection.VisibilityPredicate;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Statement;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.test.ExpectedExceptionCheckGen;
import randoop.test.ObjectCheck;
import randoop.test.RegressionChecks;
import randoop.test.TestCheckGenerator;
import randoop.types.PrimitiveTypes;
import randoop.types.Type;
import randoop.util.Log;
import randoop.util.MultiMap;

public final class RegressionCaptureGenerator
extends TestCheckGenerator {
    private @SignatureUnknown ExpectedExceptionCheckGen exceptionExpectation;
    private @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> sideEffectFreeMethodsByType;
    private final @SignatureUnknown VisibilityPredicate isVisible;
    private @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate;
    private @SignatureUnknown boolean includeAssertions;

    public RegressionCaptureGenerator(@SignatureUnknown ExpectedExceptionCheckGen exceptionExpectation, @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> sideEffectFreeMethodsByType, @SignatureUnknown VisibilityPredicate isVisible, @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @SignatureUnknown boolean includeAssertions) {
        this.exceptionExpectation = exceptionExpectation;
        this.sideEffectFreeMethodsByType = sideEffectFreeMethodsByType;
        this.isVisible = isVisible;
        this.omitMethodsPredicate = omitMethodsPredicate;
        this.includeAssertions = includeAssertions;
    }

    public @SignatureUnknown RegressionChecks generateTestChecks(@SignatureUnknown ExecutableSequence eseq) {
        RegressionChecks checks = new RegressionChecks();
        int finalIndex = eseq.sequence.size() - 1;
        for (int i = 0; i < eseq.sequence.size(); ++i) {
            Statement statement = eseq.sequence.getStatement(i);
            ExecutionOutcome result = eseq.getResult(i);
            if (result instanceof NotExecuted) {
                throw new Error("Abnormal execution in sequence: " + eseq);
            }
            if (result instanceof NormalExecution) {
                Variable var0;
                Set<TypedClassOperation> sideEffectFreeMethods;
                Type outputType;
                if (!this.includeAssertions) continue;
                NormalExecution execution = (NormalExecution)result;
                if (statement.isNonreceivingInitialization() || (outputType = statement.getOutputType()).isVoid()) continue;
                Object runtimeValue = execution.getRuntimeValue();
                Variable var = eseq.sequence.getVariable(i);
                if (runtimeValue == null) {
                    checks.add(new ObjectCheck(new IsNull(), var));
                    continue;
                }
                if (PrimitiveTypes.isBoxedPrimitive(runtimeValue.getClass()) || runtimeValue.getClass().equals(String.class)) {
                    if (Value.isUnassertableString(runtimeValue)) continue;
                    PrimValue.EqualityMode equalityMode = var.getType().isPrimitive() ? PrimValue.EqualityMode.EQUALSEQUALS : PrimValue.EqualityMode.EQUALSMETHOD;
                    ObjectCheck oc = new ObjectCheck(new PrimValue(runtimeValue, equalityMode), var);
                    checks.add(oc);
                    continue;
                }
                if (runtimeValue.getClass().isEnum() && this.isVisible.isVisible(runtimeValue.getClass())) {
                    ObjectCheck oc = new ObjectCheck(new EnumValue((Enum)runtimeValue), var);
                    checks.add(oc);
                    continue;
                }
                if (!statement.isConstructorCall()) {
                    checks.add(new ObjectCheck(new IsNotNull(), var));
                }
                if ((sideEffectFreeMethods = this.sideEffectFreeMethodsByType.getValues((var0 = eseq.sequence.getVariable(i)).getType())) == null) continue;
                for (TypedClassOperation m3 : sideEffectFreeMethods) {
                    Object value;
                    ExecutionOutcome outcome;
                    if (!RegressionCaptureGenerator.isAssertableMethod(m3, this.omitMethodsPredicate, this.isVisible) || RegressionCaptureGenerator.isObjectToString(m3) && runtimeValue.getClass() == Object.class || (outcome = m3.execute(new Object[]{runtimeValue})) instanceof ExceptionalExecution || Value.isUnassertableString(value = ((NormalExecution)outcome).getRuntimeValue())) continue;
                    ObserverEqValue observerEqValue = new ObserverEqValue(m3, value);
                    ObjectCheck observerCheck = new ObjectCheck(observerEqValue, var);
                    Log.logPrintf("Adding observer check %s%n", observerCheck);
                    checks.add(observerCheck);
                }
                continue;
            }
            if (result instanceof ExceptionalExecution) {
                if (i != finalIndex) {
                    throw new Error("Exception thrown before end of sequence");
                }
                ExceptionalExecution e = (ExceptionalExecution)result;
                checks.add(this.exceptionExpectation.getExceptionCheck(e, eseq, i));
                continue;
            }
            throw new Error("Unexecuted statement in sequence");
        }
        return checks;
    }

    private static @SignatureUnknown boolean isObjectToString(@SignatureUnknown TypedClassOperation m3) {
        Class<?> declaringClass = m3.getDeclaringType().getRuntimeClass();
        if (declaringClass == Object.class || declaringClass == Objects.class) {
            return m3.getUnqualifiedBinaryName().equals("toString");
        }
        if (declaringClass == String.class) {
            return m3.getUnqualifiedBinaryName().equals("valueOf");
        }
        return false;
    }

    public static @SignatureUnknown boolean isAssertableMethod(@SignatureUnknown TypedClassOperation m3, @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @SignatureUnknown VisibilityPredicate visibility) {
        if (omitMethodsPredicate.shouldOmit(m3)) {
            return false;
        }
        AccessibleObject executable = m3.getOperation().getReflectionObject();
        if (executable instanceof Method) {
            if (!visibility.isVisible((Method)executable)) {
                return false;
            }
        } else if (executable instanceof Constructor) {
            if (!visibility.isVisible((Constructor)executable)) {
                return false;
            }
        } else {
            throw new IllegalArgumentException("TypedClassOperation " + m3 + " must be either of type Constructor or Method.");
        }
        if (m3.getInputTypes().size() != 1) {
            return false;
        }
        if (m3.getOutputType().isVoid()) {
            return false;
        }
        Class<?> outputClass = m3.getOutputType().getRuntimeClass();
        if (outputClass == null) {
            return false;
        }
        return PrimitiveTypes.isBoxedPrimitive(outputClass) || outputClass.equals(String.class) || outputClass.isEnum();
    }
}

