/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.Arrays;
import java.util.Objects;
import randoop.contract.ObjectContract;
import randoop.contract.ObjectContractUtils;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.UtilPlume;
import randoop.sequence.Variable;
import randoop.test.Check;

public class ObjectCheck
implements Check {
    private final @SignatureUnknown ObjectContract contract;
    private final @SignatureUnknown Variable @SignatureUnknown [] vars;

    public ObjectCheck(@SignatureUnknown ObjectContract contract, Variable ... vars) {
        if (contract == null) {
            throw new IllegalArgumentException("first argument cannot be null.");
        }
        if (vars.length != contract.getArity()) {
            throw new IllegalArgumentException("vars.size() != template.getArity().");
        }
        this.contract = contract;
        this.vars = new Variable[vars.length];
        int count = 0;
        for (Variable v : vars) {
            this.vars[count++] = v;
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectCheck)) {
            return false;
        }
        ObjectCheck other = (ObjectCheck)o;
        return this.contract.equals(other.contract) && Arrays.equals(this.vars, other.vars);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.contract, Arrays.hashCode(this.vars));
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "<" + this.contract.toString() + " " + UtilPlume.escapeJava(Arrays.toString(this.vars)) + ">";
    }

    @Override
    public @SignatureUnknown String toCodeStringPreStatement() {
        return "";
    }

    @Override
    public @SignatureUnknown String toCodeStringPostStatement() {
        try {
            return ObjectContractUtils.localizeContractCode(this.contract.toCodeString(), this.vars);
        }
        catch (Exception e) {
            throw new RandoopBug("Problem with ObjectCheck " + this, e);
        }
    }
}

