/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import randoop.Globals;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.test.Check;

public class NoExceptionCheck
implements Check {
    private final @SignatureUnknown int statementIdx;
    private @SignatureUnknown String exceptionName;

    NoExceptionCheck(@SignatureUnknown int statementIdx, @SignatureUnknown String exceptionName) {
        this.statementIdx = statementIdx;
        this.exceptionName = exceptionName;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoExceptionCheck)) {
            return false;
        }
        NoExceptionCheck other = (NoExceptionCheck)o;
        return this.statementIdx == other.statementIdx;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Integer.valueOf(this.statementIdx).hashCode();
    }

    @Override
    public @SignatureUnknown String toCodeStringPostStatement() {
        return "";
    }

    @Override
    public @SignatureUnknown String toCodeStringPreStatement() {
        return "// during test generation this statement threw an exception of type " + this.exceptionName + " in error" + Globals.lineSep;
    }
}

