/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.Globals;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.UtilPlume;
import randoop.test.Check;

public class MissingExceptionCheck
implements Check {
    private final @SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ThrowsClause>> expected;
    private final @SignatureUnknown int index;

    MissingExceptionCheck(@SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ThrowsClause>> expected, @SignatureUnknown int index) {
        this.expected = expected;
        this.index = index;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MissingExceptionCheck)) {
            return false;
        }
        MissingExceptionCheck other = (MissingExceptionCheck)obj;
        return this.expected.equals(other.expected) && this.index == other.index;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.expected, this.index);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        StringBuilder result = new StringBuilder("MissingExceptionCheck at line " + this.index + Globals.lineSep);
        for (List<ThrowsClause> set : this.expected) {
            result.append(set.toString()).append(Globals.lineSep);
        }
        return result.toString();
    }

    @Override
    public @SignatureUnknown String toCodeStringPreStatement() {
        StringBuilder msg = new StringBuilder(String.format("// this statement should throw one of%n", new Object[0]));
        for (List<ThrowsClause> exceptionSet : this.expected) {
            for (ThrowsClause exception : exceptionSet) {
                msg.append(String.format("//   %s %s%n", exception.getExceptionType().getBinaryName(), exception.getComment()));
            }
        }
        return msg.toString();
    }

    @Override
    public @SignatureUnknown String toCodeStringPostStatement() {
        ArrayList<String> exceptionNameList = new ArrayList<String>();
        for (List<ThrowsClause> set : this.expected) {
            ArrayList<String> expectedNames = new ArrayList<String>();
            for (ThrowsClause exception : set) {
                expectedNames.add(exception.getExceptionType().getBinaryName());
            }
            exceptionNameList.add("\"[ " + UtilPlume.join((CharSequence)", ", expectedNames) + " ]\"");
        }
        return "org.junit.Assert.fail(\"exception is expected: \" + " + UtilPlume.join((CharSequence)" + ", exceptionNameList) + ");";
    }
}

