/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.List;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NotExecuted;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.sequence.ExecutableSequence;
import randoop.test.ErrorRevealingChecks;
import randoop.test.ExpectedExceptionCheck;
import randoop.test.MissingExceptionCheck;
import randoop.test.RegressionChecks;
import randoop.test.TestCheckGenerator;
import randoop.test.TestChecks;
import randoop.types.ClassOrInterfaceType;

public class ExpectedExceptionGenerator
extends TestCheckGenerator {
    private final @SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ThrowsClause>> exceptionSets;

    public ExpectedExceptionGenerator(@SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ThrowsClause>> exceptionSets) {
        this.exceptionSets = exceptionSets;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown TestChecks<@SignatureUnknown @SignatureBottom ?> generateTestChecks(@SignatureUnknown ExecutableSequence eseq) {
        int finalIndex = eseq.sequence.size() - 1;
        ExecutionOutcome result = eseq.getResult(finalIndex);
        if (result instanceof NotExecuted) {
            throw new Error("Abnormal execution in sequence: " + eseq);
        }
        if (result instanceof ExceptionalExecution) {
            ExceptionalExecution exec = (ExceptionalExecution)result;
            Throwable throwable = exec.getException();
            ClassOrInterfaceType throwableType = ClassOrInterfaceType.forClass(throwable.getClass());
            for (List<ThrowsClause> exceptionSet : this.exceptionSets) {
                ClassOrInterfaceType matchingType = ExpectedExceptionGenerator.findMatchingExpectedType(throwableType, exceptionSet);
                if (matchingType != null) continue;
                return this.getMissingExceptionTestChecks(finalIndex);
            }
            return new RegressionChecks(new ExpectedExceptionCheck(throwable, finalIndex, throwableType.getBinaryName()));
        }
        return this.getMissingExceptionTestChecks(finalIndex);
    }

    private static @SignatureUnknown ClassOrInterfaceType findMatchingExpectedType(@SignatureUnknown ClassOrInterfaceType throwableType, @SignatureUnknown List<@SignatureUnknown ThrowsClause> throwsClauses) {
        for (ThrowsClause exception : throwsClauses) {
            ClassOrInterfaceType expected = exception.getExceptionType();
            if (!throwableType.isSubtypeOf(expected)) continue;
            return expected;
        }
        return null;
    }

    private @SignatureUnknown ErrorRevealingChecks getMissingExceptionTestChecks(@SignatureUnknown int finalIndex) {
        ErrorRevealingChecks checks = new ErrorRevealingChecks();
        checks.add(new MissingExceptionCheck(this.exceptionSets, finalIndex));
        return checks;
    }

    public @SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ThrowsClause>> getExpected() {
        return this.exceptionSets;
    }
}

