/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.Objects;
import randoop.Globals;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.test.Check;

public abstract class ExceptionCheck
implements Check {
    protected final @SignatureUnknown Throwable exception;
    final @SignatureUnknown int statementIndex;
    private @SignatureUnknown String catchClassName;

    protected ExceptionCheck(@SignatureUnknown Throwable exception, @SignatureUnknown int statementIndex, @SignatureUnknown String catchClassName) {
        this.exception = exception;
        this.statementIndex = statementIndex;
        this.catchClassName = catchClassName;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionCheck other = (ExceptionCheck)o;
        return this.exception.equals(other.exception) && this.statementIndex == other.statementIndex;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.exception, this.statementIndex);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "// throws exception of type " + this.exception.getClass().getCanonicalName() + Globals.lineSep;
    }

    @Override
    public final @SignatureUnknown String toCodeStringPreStatement() {
        return "// The following exception was thrown during execution in test generation" + Globals.lineSep + "try {" + Globals.lineSep;
    }

    @Override
    public final @SignatureUnknown String toCodeStringPostStatement() {
        StringBuilder b = new StringBuilder();
        if (this.catchClassName == null) {
            this.catchClassName = "Exception";
        }
        this.appendTryBehavior(b);
        b.append("} catch (").append(this.catchClassName).append(" e) {").append(Globals.lineSep);
        b.append("  // Expected exception.").append(Globals.lineSep);
        this.appendCatchBehavior(b);
        b.append("}").append(Globals.lineSep);
        return b.toString();
    }

    protected abstract void appendCatchBehavior(@SignatureUnknown StringBuilder var1);

    protected abstract void appendTryBehavior(@SignatureUnknown StringBuilder var1);

    public @SignatureUnknown String getExceptionName() {
        return this.exception.getClass().getCanonicalName();
    }

    public @SignatureUnknown Throwable getException() {
        return this.exception;
    }
}

