/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.List;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.contract.ObjectContract;
import randoop.main.ExceptionBehaviorClassifier;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.ReferenceValue;
import randoop.test.Check;
import randoop.test.ContractSet;
import randoop.test.ErrorRevealingChecks;
import randoop.test.InvalidChecks;
import randoop.test.InvalidExceptionCheck;
import randoop.test.NoExceptionCheck;
import randoop.test.TestCheckGenerator;
import randoop.test.TestChecks;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.TupleSet;

public final class ContractCheckingGenerator
extends TestCheckGenerator {
    private @SignatureUnknown ContractSet contracts;

    public ContractCheckingGenerator(@SignatureUnknown ContractSet contracts) {
        this.contracts = contracts;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown TestChecks<@SignatureUnknown @SignatureBottom ?> generateTestChecks(@SignatureUnknown ExecutableSequence eseq) {
        int finalIndex = eseq.sequence.size() - 1;
        ExecutionOutcome finalResult = eseq.getResult(finalIndex);
        if (finalResult instanceof NotExecuted) {
            throw new Error("Un-executed final statement in sequence: " + eseq);
        }
        if (finalResult instanceof ExceptionalExecution) {
            ExceptionalExecution exec = (ExceptionalExecution)finalResult;
            if (ExceptionBehaviorClassifier.classify(exec, eseq) == GenInputsAbstract.BehaviorType.ERROR) {
                String exceptionName = exec.getException().getClass().getName();
                NoExceptionCheck obs = new NoExceptionCheck(finalIndex, exceptionName);
                return new ErrorRevealingChecks(obs);
            }
            return ErrorRevealingChecks.EMPTY;
        }
        assert (finalResult instanceof NormalExecution);
        if (!this.contracts.isEmpty()) {
            Check check;
            Check check2;
            List<ReferenceValue> statementValues = eseq.getLastStatementValues();
            List<ObjectContract> unaryContracts = this.contracts.getWithArity(1);
            if (!unaryContracts.isEmpty()) {
                TupleSet<ReferenceValue> statementTuples = new TupleSet<ReferenceValue>();
                Check check3 = this.checkContracts(unaryContracts, eseq, statementTuples = statementTuples.extend(statementValues));
                if (check3 != null) {
                    return this.singletonTestCheck(check3);
                }
            }
            List<ReferenceValue> inputValues = eseq.getInputValues();
            TupleSet<Object> inputTuples = new TupleSet<ReferenceValue>();
            inputTuples = inputTuples.extend(inputValues).extend(inputValues);
            List<ObjectContract> binaryContracts = this.contracts.getWithArity(2);
            if (!binaryContracts.isEmpty() && (check2 = this.checkContracts(binaryContracts, eseq, inputTuples)) != null) {
                return this.singletonTestCheck(check2);
            }
            TupleSet<ReferenceValue> ternaryTuples = inputTuples.exhaustivelyExtend(statementValues);
            List<ObjectContract> ternaryContracts = this.contracts.getWithArity(3);
            if (!ternaryContracts.isEmpty() && (check = this.checkContracts(ternaryContracts, eseq, ternaryTuples)) != null) {
                return this.singletonTestCheck(check);
            }
        }
        return ErrorRevealingChecks.EMPTY;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown TestChecks<@SignatureUnknown @SignatureBottom ?> singletonTestCheck(@SignatureUnknown Check check) {
        if (check instanceof InvalidExceptionCheck) {
            return new InvalidChecks((InvalidExceptionCheck)check);
        }
        return new ErrorRevealingChecks(check);
    }

    @SignatureUnknown Check checkContracts(@SignatureUnknown List<@SignatureUnknown ObjectContract> contracts, @SignatureUnknown ExecutableSequence eseq, @SignatureUnknown TupleSet<@SignatureUnknown ReferenceValue> tuples) {
        for (List<ReferenceValue> tuple : tuples.tuples()) {
            Object[] values = ContractCheckingGenerator.getValues(tuple);
            for (ObjectContract contract : contracts) {
                Check check;
                assert (tuple.size() == contract.getArity()) : "value tuple size " + tuple.size() + " must match contract arity " + contract.getArity();
                if (!ContractCheckingGenerator.typesMatch(contract.getInputTypes(), tuple) || (check = contract.checkContract(eseq, values)) == null) continue;
                return check;
            }
        }
        return null;
    }

    public static @SignatureUnknown boolean typesMatch(@SignatureUnknown TypeTuple inputTypes, @SignatureUnknown List<@SignatureUnknown ReferenceValue> valueTuple) {
        if (inputTypes.size() != valueTuple.size()) {
            return false;
        }
        Substitution substitution = new Substitution();
        for (int i = 0; i < inputTypes.size(); ++i) {
            Type inputType = inputTypes.get(i);
            ReferenceType valueType = valueTuple.get(i).getType();
            if (inputType.isGeneric()) {
                if (valueType instanceof ClassOrInterfaceType) {
                    ClassOrInterfaceType classType = (ClassOrInterfaceType)valueType;
                    InstantiatedType superType = classType.getMatchingSupertype((GenericClassType)inputTypes.get(i));
                    if (superType == null) {
                        return false;
                    }
                    Substitution subst = superType.getTypeSubstitution();
                    if (!substitution.isConsistentWith(subst)) {
                        return false;
                    }
                    substitution = substitution.extend(subst);
                    continue;
                }
                return false;
            }
            if (inputType.isAssignableFrom(valueType)) continue;
            return false;
        }
        return true;
    }

    private static @SignatureUnknown Object @SignatureUnknown [] getValues(@SignatureUnknown List<@SignatureUnknown ReferenceValue> tuple) {
        Object[] values = new Object[tuple.size()];
        for (int i = 0; i < tuple.size(); ++i) {
            values[i] = tuple.get(i).getObjectValue();
        }
        return values;
    }
}

