/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import randoop.com.github.javaparser.ast.CompilationUnit;
import randoop.com.github.javaparser.ast.PackageDeclaration;
import randoop.compile.SequenceCompiler;
import randoop.main.GenTests;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.output.JUnitCreator;
import randoop.output.NameGenerator;
import randoop.sequence.ExecutableSequence;
import randoop.util.Log;

public class CompilableTestPredicate
implements Predicate<ExecutableSequence> {
    private final @SignatureUnknown SequenceCompiler compiler;
    private final @SignatureUnknown JUnitCreator junitCreator;
    private final @SignatureUnknown NameGenerator classNameGenerator;
    private final @SignatureUnknown NameGenerator methodNameGenerator;
    private final @SignatureUnknown GenTests genTests;

    public CompilableTestPredicate(@SignatureUnknown JUnitCreator junitCreator, @SignatureUnknown GenTests genTests) {
        ArrayList<String> compilerOptions = new ArrayList<String>();
        compilerOptions.add("-Xmaxerrs");
        compilerOptions.add("1");
        compilerOptions.add("-implicit:none");
        compilerOptions.add("-proc:none");
        compilerOptions.add("-g:none");
        compilerOptions.add("-Xlint:none");
        this.compiler = new SequenceCompiler(compilerOptions);
        this.junitCreator = junitCreator;
        this.classNameGenerator = new NameGenerator("RandoopTemporarySeqTest");
        this.methodNameGenerator = new NameGenerator("theSequence");
        this.genTests = genTests;
    }

    @Override
    public @SignatureUnknown boolean test(@SignatureUnknown ExecutableSequence eseq) {
        List<ExecutableSequence> sequences;
        String testClassName;
        CompilationUnit source;
        Optional<PackageDeclaration> oPkg = (source = this.junitCreator.createTestClass(testClassName = this.classNameGenerator.next(), this.methodNameGenerator, sequences = Collections.singletonList(eseq))).getPackageDeclaration();
        String packageName = oPkg.isPresent() ? oPkg.get().getName().toString() : null;
        boolean result = this.testSource(testClassName, source, packageName);
        if (!result) {
            this.genTests.incrementSequenceCompileFailureCount();
            Log.logPrintf("%nCompilableTestPredicate => false for%n%nsequence =%n%s%nsource =%n%s%n", eseq, source);
        }
        return result;
    }

    @SignatureUnknown boolean testSource(@SignatureUnknown String testClassName, @SignatureUnknown CompilationUnit source, @SignatureUnknown String packageName) {
        String sourceText = source.toString();
        return this.compiler.isCompilable(packageName, testClassName, sourceText);
    }
}

