/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.sequence.Sequence;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.ReferenceArgument;
import randoop.types.Type;
import randoop.types.TypeArgument;

class VariableRenamer {
    public final @SignatureUnknown Sequence sequence;
    private static final @SignatureUnknown int VAR_NAME_MAX_DEPTH = 2;

    public VariableRenamer(@SignatureUnknown Sequence sequence) {
        assert (sequence != null) : "The given sequence to rename cannot be null";
        this.sequence = sequence;
    }

    static @SignatureUnknown String getVariableName(@SignatureUnknown Type type) {
        String varName = VariableRenamer.getVariableName(type, 2);
        if (Character.isUpperCase(varName.charAt(0))) {
            varName = VariableRenamer.lowercaseFirstCharacter(varName);
        }
        if (Character.isDigit(varName.charAt(varName.length() - 1))) {
            varName = varName + "_";
        }
        return varName;
    }

    private static @SignatureUnknown String getVariableName(@SignatureUnknown Type type, @SignatureUnknown int depth) {
        if (type.isVoid()) {
            return "void";
        }
        if (type.equals(JavaTypes.CLASS_TYPE)) {
            return "cls";
        }
        if (type.isObject()) {
            return "obj";
        }
        if (type.isString()) {
            return "str";
        }
        if (type.isBoxedPrimitive()) {
            type = ((NonParameterizedType)type).toPrimitive();
        }
        if (type.isPrimitive()) {
            return type.getFqName();
        }
        if (type.isArray()) {
            while (type.isArray()) {
                type = ((ArrayType)type).getComponentType();
            }
            return VariableRenamer.getVariableName(type, depth - 1) + "Array";
        }
        String varName = type.getSimpleName();
        if (varName.length() == 0) {
            return "anonymous";
        }
        if (type.isParameterized()) {
            Class<?> typeClass = type.getRuntimeClass();
            if (Iterator.class.isAssignableFrom(typeClass)) {
                varName = "itor";
            } else if (List.class.isAssignableFrom(typeClass)) {
                varName = "list";
            } else if (Set.class.isAssignableFrom(typeClass)) {
                varName = "set";
            } else if (Map.class.isAssignableFrom(typeClass)) {
                varName = "map";
            } else if (Queue.class.isAssignableFrom(typeClass)) {
                varName = "queue";
            } else if (Collection.class.isAssignableFrom(typeClass)) {
                varName = "collection";
            }
            List<TypeArgument> arglist = ((ClassOrInterfaceType)type).getTypeArguments();
            if (!arglist.isEmpty()) {
                TypeArgument argument = arglist.get(0);
                if (argument.isWildcard()) {
                    varName = "wildcard" + VariableRenamer.capitalizeString(varName);
                } else if (depth >= 0) {
                    String argumentName = VariableRenamer.getVariableName(((ReferenceArgument)argument).getReferenceType(), depth - 1);
                    varName = argumentName + VariableRenamer.capitalizeString(varName);
                }
            }
        }
        return varName;
    }

    private static @SignatureUnknown String capitalizeString(@SignatureUnknown String variableName) {
        return variableName.substring(0, 1).toUpperCase() + variableName.substring(1);
    }

    private static @SignatureUnknown String lowercaseFirstCharacter(@SignatureUnknown String variableName) {
        return variableName.substring(0, 1).toLowerCase() + variableName.substring(1);
    }
}

