/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Sequence;
import randoop.sequence.Statement;
import randoop.sequence.VariableRenamer;
import randoop.types.Type;

public class Variable
implements Comparable<Variable> {
    public final @SignatureUnknown int index;
    public final @SignatureUnknown Sequence sequence;

    public Variable(@SignatureUnknown Sequence owner, @SignatureUnknown int i) {
        if (owner == null) {
            throw new IllegalArgumentException("missing owner");
        }
        if (i < 0) {
            throw new IllegalArgumentException("negative index: " + i);
        }
        this.sequence = owner;
        this.index = i;
    }

    protected Variable() {
        this.index = 0;
        this.sequence = null;
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.getName();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)o;
        return this.index == other.index;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return this.index * this.sequence.hashCode();
    }

    public @SignatureUnknown Type getType() {
        return this.sequence.getStatement(this.index).getOutputType();
    }

    public @SignatureUnknown Statement getDeclaringStatement() {
        return this.sequence.getStatement(this.index);
    }

    public @SignatureUnknown int getDeclIndex() {
        return this.index;
    }

    public @SignatureUnknown String getName() {
        return this.getName(Variable.classToVariableName(this.getType()), this.index);
    }

    private @SignatureUnknown String getName(@SignatureUnknown String className, @SignatureUnknown int i) {
        String basename = Variable.classNameToVariableName(className);
        return basename + Integer.toString(i);
    }

    @Override
    @Pure
    public @SignatureUnknown int compareTo(@SignatureUnknown Variable o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (o.sequence != this.sequence) {
            throw new IllegalArgumentException();
        }
        return Integer.valueOf(this.index).compareTo(o.index);
    }

    static @SignatureUnknown String classToVariableName(@SignatureUnknown Type type) {
        return VariableRenamer.getVariableName(type);
    }

    private static @SignatureUnknown String classNameToVariableName(@SignatureUnknown String className) {
        assert (!className.contains("."));
        assert (!className.contains("["));
        assert (!className.equals(""));
        return Character.toLowerCase(className.charAt(0)) + className.substring(1);
    }

    public @SignatureUnknown boolean shouldInlineLiterals() {
        return this.sequence.shouldInlineLiterals();
    }
}

