/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.Globals;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Sequence;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class Statement {
    private final @SignatureUnknown TypedOperation operation;
    final @SignatureUnknown List<@SignatureUnknown Sequence.RelativeNegativeIndex> inputs;

    public Statement(@SignatureUnknown TypedOperation operation, @SignatureUnknown List<@SignatureUnknown Sequence.RelativeNegativeIndex> inputVariables) {
        this.operation = operation;
        this.inputs = new ArrayList<Sequence.RelativeNegativeIndex>(inputVariables);
    }

    public Statement(@SignatureUnknown TypedOperation operation) {
        this(operation, new ArrayList<Sequence.RelativeNegativeIndex>());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement s2 = (Statement)obj;
        if (!this.operation.equals(s2.operation)) {
            return false;
        }
        if (this.inputs.size() != s2.inputs.size()) {
            return false;
        }
        for (int j = 0; j < this.inputs.size(); ++j) {
            if (this.inputs.get(j).equals(s2.inputs.get(j))) continue;
            return false;
        }
        return true;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.operation, this.inputs);
    }

    public @SignatureUnknown Type getOutputType() {
        return this.operation.getOutputType();
    }

    public @SignatureUnknown TypeTuple getInputTypes() {
        return this.operation.getInputTypes();
    }

    public void appendCode(@SignatureUnknown Variable variable, @SignatureUnknown List<@SignatureUnknown Variable> inputs, @SignatureUnknown StringBuilder b) {
        Type type = this.operation.getOutputType();
        if (!type.isVoid()) {
            if (this.operation.isUncheckedCast()) {
                b.append("@SuppressWarnings(\"unchecked\")").append(Globals.lineSep);
            }
            String typeName = type.getFqName();
            b.append(typeName);
            b.append(" ").append(Variable.classToVariableName(type)).append(variable.index).append(" = ");
        }
        this.operation.appendCode(inputs, b);
        b.append(";");
    }

    public @SignatureUnknown String toParsableString(@SignatureUnknown String variableName, @SignatureUnknown List<@SignatureUnknown Variable> inputs) {
        StringBuilder b = new StringBuilder();
        b.append(variableName);
        b.append(" =  ");
        b.append(this.operation.getClass().getSimpleName());
        b.append(" : ");
        b.append(this.operation.toParsableString());
        b.append(" : ");
        for (Variable v : inputs) {
            b.append(v.toString());
            b.append(" ");
        }
        return b.toString();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "Statement [ " + this.operation + "]";
    }

    public @SignatureUnknown boolean isStatic() {
        return this.operation.isStatic();
    }

    public @SignatureUnknown boolean isMethodCall() {
        return this.operation.isMessage();
    }

    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] inputs) {
        return this.operation.execute(inputs);
    }

    public @SignatureUnknown Type getDeclaringClass() {
        if (this.operation instanceof TypedClassOperation) {
            return ((TypedClassOperation)this.operation).getDeclaringType();
        }
        return null;
    }

    public @SignatureUnknown boolean isConstructorCall() {
        return this.operation.isConstructorCall();
    }

    public @SignatureUnknown boolean isNonreceivingInitialization() {
        return this.operation.isNonreceivingValue();
    }

    public @SignatureUnknown boolean isNullInitialization() {
        return this.isNonreceivingInitialization() && this.operation.getValue() == null;
    }

    public @SignatureUnknown String getInlinedForm() {
        if (this.isNonreceivingInitialization() && !this.isNullInitialization()) {
            return Value.toCodeString(this.operation.getValue());
        }
        return null;
    }

    public @SignatureUnknown Object getValue() {
        return this.operation.getValue();
    }

    public final @SignatureUnknown TypedOperation getOperation() {
        return this.operation;
    }
}

