/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.TypeVariable;

class TypeTupleSet {
    private @SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ReferenceType>> typeTuples = new ArrayList<List<ReferenceType>>();
    private @SignatureUnknown int tupleLength;

    TypeTupleSet() {
        this.typeTuples.add(new ArrayList());
        this.tupleLength = 0;
    }

    public void extend(@SignatureUnknown List<@SignatureUnknown ReferenceType> types) {
        ++this.tupleLength;
        ArrayList<List<ReferenceType>> tupleList = new ArrayList<List<ReferenceType>>();
        for (List<ReferenceType> tuple : this.typeTuples) {
            for (ReferenceType type : types) {
                ArrayList<ReferenceType> extTuple = new ArrayList<ReferenceType>(tuple);
                extTuple.add(type);
                assert (extTuple.size() == this.tupleLength) : "tuple lengths don't match, expected: " + this.tupleLength + " have " + extTuple.size();
                tupleList.add(extTuple);
            }
        }
        this.typeTuples = tupleList;
    }

    @SignatureUnknown List<@SignatureUnknown Substitution> filter(@SignatureUnknown List<@SignatureUnknown TypeVariable> typeParameters) {
        assert (typeParameters.size() == this.tupleLength) : "tuple size " + this.tupleLength + " must equal number of parameters " + typeParameters.size();
        ArrayList<Substitution> substitutionSet = new ArrayList<Substitution>();
        ArrayList<List<ReferenceType>> tupleList = new ArrayList<List<ReferenceType>>();
        for (List<ReferenceType> tuple : this.typeTuples) {
            int i;
            Substitution substitution = new Substitution(typeParameters, tuple);
            for (i = 0; i < tuple.size() && typeParameters.get(i).getUpperTypeBound().isUpperBound(tuple.get(i), substitution); ++i) {
            }
            if (i != tuple.size()) continue;
            substitutionSet.add(substitution);
            tupleList.add(tuple);
        }
        this.typeTuples = tupleList;
        return substitutionSet;
    }
}

