/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.reflection.DefaultClassVisitor;
import randoop.reflection.ReflectionManager;
import randoop.reflection.VisibilityPredicate;
import randoop.types.ClassOrInterfaceType;
import randoop.types.ParameterizedType;
import randoop.types.PrimitiveType;
import randoop.util.Log;

class TypeExtractor
extends DefaultClassVisitor {
    private @SignatureUnknown Set<@SignatureUnknown randoop.types.Type> inputTypes;
    private final @SignatureUnknown VisibilityPredicate predicate;

    TypeExtractor(@SignatureUnknown Set<@SignatureUnknown randoop.types.Type> inputTypes, @SignatureUnknown VisibilityPredicate predicate) {
        this.inputTypes = inputTypes;
        this.predicate = predicate;
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c, @SignatureUnknown ReflectionManager reflectionManager) {
        this.addIfConcrete(ClassOrInterfaceType.forClass(c));
        reflectionManager.apply(this, c);
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> c) {
        for (Type paramType : c.getGenericParameterTypes()) {
            this.addIfConcrete(randoop.types.Type.forType(paramType));
        }
    }

    @Override
    public void visit(@SignatureUnknown Method m3) {
        if (m3.isBridge()) {
            return;
        }
        for (Type paramType : m3.getGenericParameterTypes()) {
            this.addIfConcrete(randoop.types.Type.forType(paramType));
        }
        Type returnType = m3.getGenericReturnType();
        this.addIfConcrete(randoop.types.Type.forType(returnType));
    }

    @Override
    public void visit(@SignatureUnknown Field f) {
        Type fieldType = f.getGenericType();
        this.addIfConcrete(randoop.types.Type.forType(fieldType));
    }

    private void addIfConcrete(@SignatureUnknown randoop.types.Type type) {
        if (!(type.isVoid() || type.isGeneric() || type.isParameterized() && ((ParameterizedType)type).hasWildcard())) {
            if (!this.predicate.isVisible(type.getRuntimeClass())) {
                return;
            }
            if (type.isPrimitive()) {
                type = ((PrimitiveType)type).toBoxedPrimitive();
            }
            Log.logPrintf("Adding %s [%s] as candidate parameter type%n", type, type.getClass());
            this.inputTypes.add(type);
        }
    }

    @Override
    public void visitBefore(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        if (c.getTypeParameters().length == 0) {
            this.inputTypes.add(ClassOrInterfaceType.forClass(c));
        }
    }
}

