/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class StaticCache {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> declaringClass;
    private final @SignatureUnknown Map<@SignatureUnknown Field, @SignatureUnknown Object> valueMap;

    public StaticCache(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> declaringClass) {
        this.declaringClass = declaringClass;
        this.valueMap = new LinkedHashMap<Field, Object>();
    }

    public void printCache() {
        for (Map.Entry<Field, Object> entry : this.valueMap.entrySet()) {
            System.out.println(this.declaringClass.getName() + "." + entry.getKey().getName() + " = " + entry.getValue());
        }
    }

    public void saveState() {
        for (Field field : this.declaringClass.getDeclaredFields()) {
            Object value;
            field.setAccessible(true);
            int mods = Modifier.fieldModifiers() & field.getModifiers();
            if (!Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            try {
                value = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RandoopBug("unable to save value of field " + field.getName());
            }
            this.valueMap.put(field, value);
        }
    }

    public void restoreState() {
        for (Map.Entry<Field, Object> entry : this.valueMap.entrySet()) {
            try {
                entry.getKey().set(null, entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RandoopBug("unable to save value of field " + entry.getKey());
            }
        }
    }
}

