/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.util.ClassDeterministic;
import randoop.reflection.ClassVisitor;
import randoop.reflection.VisibilityPredicate;
import randoop.util.Log;

public class ReflectionManager {
    private @SignatureUnknown VisibilityPredicate predicate;
    private @SignatureUnknown ArrayList<@SignatureUnknown ClassVisitor> visitors;

    public ReflectionManager(@SignatureUnknown VisibilityPredicate predicate) {
        this.predicate = predicate;
        this.visitors = new ArrayList();
    }

    public void add(@SignatureUnknown ClassVisitor visitor) {
        this.visitors.add(visitor);
    }

    public void apply(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        for (ClassVisitor visitor : this.visitors) {
            this.apply(visitor, c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@SignatureUnknown ClassVisitor visitor, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        Log.logPrintf("Applying visitor %s to class %s%n", visitor, c.getName());
        if (!this.predicate.isVisible(c)) {
            Log.logPrintln("ReflectionManager.apply: class " + c + " is not visible");
            return;
        }
        this.visitBefore(visitor, c);
        if (c.isEnum()) {
            this.applyToEnum(visitor, c);
        } else {
            void var7_19;
            Field f;
            void var7_17;
            try {
                Log.logPrintf("ReflectionManager.apply%n  %s%n  getMethods = %d%n  getDeclaredMethods = %d%n  visitor = %s%n", c, ClassDeterministic.getMethods(c).length, ClassDeterministic.getDeclaredMethods(c).length, visitor);
            }
            catch (Throwable e) {
                throw new Error(String.format("Problem with ReflectionManager.apply(%s, %s)", visitor, c), e);
            }
            HashSet<Method> methods = new HashSet<Method>();
            for (Method method : ClassDeterministic.getMethods(c)) {
                methods.add(method);
                if (this.isVisible(method)) {
                    this.applyTo(visitor, method);
                    continue;
                }
                Log.logPrintln("ReflectionManager.apply: method " + method + " is not visible");
            }
            Log.logPrintf("ReflectionManager.apply done with getMethods for class %s%n", c);
            for (Method method : ClassDeterministic.getDeclaredMethods(c)) {
                if (methods.contains(method)) continue;
                if (this.isVisible(method)) {
                    this.applyTo(visitor, method);
                    continue;
                }
                Log.logPrintln("ReflectionManager.apply: declared method " + method + " is not visible");
            }
            Log.logPrintf("ReflectionManager.apply done with getDeclaredMethods for class %s%n", c);
            for (Executable executable : ClassDeterministic.getDeclaredConstructors(c)) {
                if (!this.isVisible((Constructor<?>)executable)) continue;
                this.applyTo(visitor, (Constructor<?>)executable);
            }
            for (GenericDeclaration genericDeclaration : ClassDeterministic.getDeclaredClasses(c)) {
                if (!this.isVisible((Type)((Object)genericDeclaration))) continue;
                this.applyTo(visitor, (Class<?>)genericDeclaration);
            }
            TreeSet<String> declaredNames = new TreeSet<String>();
            Field[] fieldArray = ClassDeterministic.getDeclaredFields(c);
            int n = fieldArray.length;
            boolean bl = false;
            while (var7_17 < n) {
                f = fieldArray[var7_17];
                declaredNames.add(f.getName());
                if (this.predicate.isVisible(f)) {
                    this.applyTo(visitor, f);
                }
                ++var7_17;
            }
            fieldArray = ClassDeterministic.getFields(c);
            n = fieldArray.length;
            boolean bl2 = false;
            while (var7_19 < n) {
                f = fieldArray[var7_19];
                if (this.predicate.isVisible(f) && !declaredNames.contains(f.getName())) {
                    this.applyTo(visitor, f);
                }
                ++var7_19;
            }
        }
        this.visitAfter(visitor, c);
    }

    private void applyToEnum(@SignatureUnknown ClassVisitor visitor, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        HashMap<String, LinkedHashSet<Method>> overrideMethods = new HashMap<String, LinkedHashSet<Method>>();
        for (Object obj : c.getEnumConstants()) {
            Enum e = (Enum)obj;
            this.applyTo(visitor, e);
            if (e.getClass().equals(c)) continue;
            for (Method m3 : e.getClass().getDeclaredMethods()) {
                LinkedHashSet<Method> methodSet = (LinkedHashSet<Method>)overrideMethods.get(m3.getName());
                if (methodSet == null) {
                    methodSet = new LinkedHashSet<Method>();
                }
                methodSet.add(m3);
                overrideMethods.put(m3.getName(), methodSet);
            }
        }
        for (Method method : ClassDeterministic.getDeclaredMethods(c)) {
            if (!this.isVisible(method) || method.getName().equals("values") || method.getName().equals("valueOf")) continue;
            this.applyTo(visitor, method);
        }
        for (Method method : ClassDeterministic.getMethods(c)) {
            Set methodSet;
            if (!this.isVisible(method) || (methodSet = (Set)overrideMethods.get(method.getName())) == null) continue;
            for (Method method2 : methodSet) {
                this.applyTo(visitor, method2);
            }
        }
    }

    private void applyTo(@SignatureUnknown ClassVisitor v, @SignatureUnknown Field f) {
        Log.logPrintf("Visiting field %s%n", f.toGenericString());
        v.visit(f);
    }

    private void applyTo(@SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        Log.logPrintf("Visiting member class %s%n", c.toString());
        v.visit(c, this);
    }

    private void applyTo(@SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> co) {
        Log.logPrintf("Visiting constructor %s%n", co.toGenericString());
        v.visit(co);
    }

    private void applyTo(@SignatureUnknown ClassVisitor v, @SignatureUnknown Method m3) {
        Log.logPrintf("ReflectionManager visiting method %s, visitor=%s%n", m3.toGenericString(), v);
        v.visit(m3);
    }

    private void applyTo(@SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> e) {
        Log.logPrintf("Visiting enum %s%n", e);
        v.visit(e);
    }

    private void visitBefore(@SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        v.visitBefore(c);
    }

    private void visitAfter(@SignatureUnknown ClassVisitor v, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        v.visitAfter(c);
    }

    private @SignatureUnknown boolean isVisible(@SignatureUnknown Method m3) {
        if (!this.predicate.isVisible(m3)) {
            Log.logPrintf("Will not use non-visible method: %s%n", m3.toGenericString());
            return false;
        }
        if (!this.isVisible(m3.getGenericReturnType())) {
            Log.logPrintf("Will not use method with non-visible return type: %s%n", m3.toGenericString());
            return false;
        }
        for (Type p : m3.getGenericParameterTypes()) {
            if (this.isVisible(p)) continue;
            Log.logPrintf("Will not use method with non-visible parameter %s: %s%n", p, m3.toGenericString());
            return false;
        }
        return true;
    }

    private @SignatureUnknown boolean isVisible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> c) {
        if (!this.predicate.isVisible(c)) {
            Log.logPrintf("Will not use non-visible constructor: %s%n", c.toGenericString());
            return false;
        }
        for (Type p : c.getGenericParameterTypes()) {
            if (this.isVisible(p)) continue;
            Log.logPrintf("Will not use constructor with non-visible parameter %s: %s%n", p, c.toGenericString());
            return false;
        }
        return true;
    }

    private @SignatureUnknown boolean isVisible(@SignatureUnknown Type type) {
        if (type instanceof GenericArrayType) {
            return this.isVisible(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            if (!this.isVisible(((ParameterizedType)type).getRawType())) {
                return false;
            }
            for (Type argType : ((ParameterizedType)type).getActualTypeArguments()) {
                if (this.isVisible(argType)) continue;
                return false;
            }
            return true;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof WildcardType) {
            return true;
        }
        Class rawType = (Class)type;
        return this.predicate.isVisible(rawType);
    }
}

