/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.UtilPlume;

public class RawSignature {
    private final @DotSeparatedIdentifiers String packageName;
    private final @SignatureUnknown String classname;
    private final @SignatureUnknown String name;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> @SignatureUnknown [] parameterTypes;

    public RawSignature(@DotSeparatedIdentifiers String packageName, @SignatureUnknown String classname, @SignatureUnknown String name, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> @SignatureUnknown [] parameterTypes) {
        this.packageName = packageName;
        this.classname = classname;
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public static @SignatureUnknown RawSignature of(@SignatureUnknown Method executable) {
        Package classPackage = executable.getDeclaringClass().getPackage();
        String packageName = classPackage == null ? null : classPackage.getName();
        String fullclassname = executable.getDeclaringClass().getName();
        String classname = packageName == null ? fullclassname : fullclassname.substring(packageName.length() + 1);
        return new RawSignature(packageName, classname, executable.getName(), executable.getParameterTypes());
    }

    public static @SignatureUnknown RawSignature of(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> executable) {
        Package classPackage = executable.getDeclaringClass().getPackage();
        String packageName = classPackage == null ? null : classPackage.getName();
        String fullclassname = executable.getDeclaringClass().getName();
        String classname = packageName == null ? fullclassname : fullclassname.substring(packageName.length() + 1);
        String fullname = executable.getName();
        String name = packageName == null ? fullname : fullname.substring(packageName.length() + 1);
        return new RawSignature(packageName, classname, name, executable.getParameterTypes());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RawSignature)) {
            return false;
        }
        RawSignature that = (RawSignature)object;
        return Objects.equals(this.packageName, that.packageName) && this.classname.equals(that.classname) && this.name.equals(that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.classname, this.name, Arrays.hashCode(this.parameterTypes));
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (Class<?> type : this.parameterTypes) {
            typeNames.add(type.getCanonicalName());
        }
        return (this.packageName == null ? "" : this.packageName + ".") + (this.classname.equals(this.name) ? this.name : this.classname + "." + this.name) + "(" + UtilPlume.join((CharSequence)",", typeNames) + ")";
    }

    public @DotSeparatedIdentifiers String getPackageName() {
        return this.packageName;
    }

    public @SignatureUnknown String getClassname() {
        return this.classname;
    }

    public @SignatureUnknown String getName() {
        return this.name;
    }

    public @SignatureUnknown String getDeclarationArguments(@SignatureUnknown List<@SignatureUnknown String> parameterNames) {
        if (parameterNames.size() != this.parameterTypes.length) {
            throw new IllegalArgumentException(String.format("Number of parameter names %d (%s) must match the number of parameter types %d (%s) for %s", parameterNames.size(), parameterNames, this.parameterTypes.length, Arrays.toString(this.parameterTypes), this));
        }
        ArrayList<String> paramDeclarations = new ArrayList<String>();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            paramDeclarations.add(this.parameterTypes[i].getCanonicalName() + " " + parameterNames.get(i));
        }
        return "(" + UtilPlume.join((CharSequence)", ", paramDeclarations) + ")";
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> @SignatureUnknown [] getParameterTypes() {
        return this.parameterTypes;
    }
}

