/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import randoop.condition.ExecutableSpecification;
import randoop.condition.SpecificationCollection;
import randoop.main.RandoopBug;
import randoop.operation.EnumConstant;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.reflection.DefaultClassVisitor;
import randoop.reflection.OmitMethodsPredicate;
import randoop.reflection.ReflectionManager;
import randoop.reflection.ReflectionPredicate;
import randoop.reflection.VisibilityPredicate;
import randoop.types.ClassOrInterfaceType;
import randoop.types.NonParameterizedType;
import randoop.types.Substitution;
import randoop.types.TypeTuple;
import randoop.util.Log;

public class OperationExtractor
extends DefaultClassVisitor {
    private static @SignatureUnknown boolean debug = false;
    private @SignatureUnknown ClassOrInterfaceType classType;
    private final @SignatureUnknown Collection<@SignatureUnknown TypedOperation> operations = new TreeSet<TypedOperation>();
    private final @SignatureUnknown ReflectionPredicate reflectionPredicate;
    private @SignatureUnknown OmitMethodsPredicate omitPredicate;
    private final @SignatureUnknown VisibilityPredicate visibilityPredicate;
    private final @SignatureUnknown SpecificationCollection operationSpecifications;

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> clazz, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        return OperationExtractor.operations(clazz, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, visibilityPredicate, null);
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(@SignatureUnknown ClassOrInterfaceType classType, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        return OperationExtractor.operations(classType, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, visibilityPredicate, null);
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(@SignatureUnknown Collection<@SignatureUnknown ClassOrInterfaceType> classTypes, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        return OperationExtractor.operations(classTypes, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, visibilityPredicate, null);
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> clazz, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        return OperationExtractor.operations(clazz, reflectionPredicate, omitPredicate, visibilityPredicate, null);
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(@SignatureUnknown ClassOrInterfaceType classType, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        return OperationExtractor.operations(classType, reflectionPredicate, omitPredicate, visibilityPredicate, null);
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(@SignatureUnknown Collection<@SignatureUnknown ClassOrInterfaceType> classTypes, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        return OperationExtractor.operations(classTypes, reflectionPredicate, omitPredicate, visibilityPredicate, null);
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> clazz, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate, @SignatureUnknown SpecificationCollection operationSpecifications) {
        return OperationExtractor.operations(ClassOrInterfaceType.forClass(clazz), reflectionPredicate, omitMethodsPredicate, visibilityPredicate, operationSpecifications);
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(@SignatureUnknown ClassOrInterfaceType classType, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate, @SignatureUnknown SpecificationCollection operationSpecifications) {
        ReflectionManager mgr = new ReflectionManager(visibilityPredicate);
        OperationExtractor extractor = new OperationExtractor(classType, reflectionPredicate, omitMethodsPredicate, visibilityPredicate, operationSpecifications);
        mgr.apply(extractor, classType.getRuntimeClass());
        return new ArrayList<TypedOperation>(extractor.getOperations());
    }

    public static @SignatureUnknown List<@SignatureUnknown TypedOperation> operations(@SignatureUnknown Collection<@SignatureUnknown ClassOrInterfaceType> classTypes, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate, @SignatureUnknown SpecificationCollection operationSpecifications) {
        TreeSet<TypedOperation> result = new TreeSet<TypedOperation>();
        ReflectionManager mgr = new ReflectionManager(visibilityPredicate);
        for (ClassOrInterfaceType classType : classTypes) {
            OperationExtractor extractor = new OperationExtractor(classType, reflectionPredicate, omitMethodsPredicate, visibilityPredicate, operationSpecifications);
            mgr.apply(extractor, classType.getRuntimeClass());
            result.addAll(extractor.getOperations());
        }
        return new ArrayList<TypedOperation>(result);
    }

    public static @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> classListToTypeList(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown List<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> classes) {
        ArrayList<ClassOrInterfaceType> result = new ArrayList<ClassOrInterfaceType>();
        for (Class<?> c : classes) {
            result.add(ClassOrInterfaceType.forClass(c));
        }
        return result;
    }

    public OperationExtractor(@SignatureUnknown ClassOrInterfaceType classType, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate, @SignatureUnknown SpecificationCollection operationSpecifications) {
        this.classType = classType;
        this.reflectionPredicate = reflectionPredicate;
        this.omitPredicate = omitPredicate;
        this.visibilityPredicate = visibilityPredicate;
        this.operationSpecifications = operationSpecifications;
    }

    public OperationExtractor(@SignatureUnknown ClassOrInterfaceType classType, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        this(classType, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, visibilityPredicate, null);
    }

    public OperationExtractor(@SignatureUnknown ClassOrInterfaceType classType, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown OmitMethodsPredicate omitPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        this(classType, reflectionPredicate, omitPredicate, visibilityPredicate, null);
    }

    private @SignatureUnknown TypedClassOperation instantiateTypes(@SignatureUnknown TypedClassOperation operation) {
        if (!this.classType.isGeneric() && operation.getDeclaringType().isGeneric()) {
            Substitution substitution = this.classType.getInstantiatingSubstitution(operation.getDeclaringType());
            if (substitution == null) {
                throw new RandoopBug(String.format("Type %s for operation %s is not a subtype of an instantiation of declaring class of method %s", this.classType, operation, operation.getDeclaringType()));
            }
            if ((operation = operation.substitute(substitution)) == null) {
                throw new RandoopBug("Instantiation of operation failed");
            }
        }
        return operation;
    }

    private void checkSubTypes(@SignatureUnknown TypedClassOperation operation) {
        ClassOrInterfaceType declaringType = operation.getDeclaringType();
        if (!this.classType.isSubtypeOf(declaringType)) {
            throw new RandoopBug(String.format("Incompatible receiver type for operation %s:%n  %s%nis not a subtype of%n  %s", operation, Log.toStringAndClass(this.classType), Log.toStringAndClass(declaringType)));
        }
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> constructor) {
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: constructor=" + constructor);
        }
        assert (constructor.getDeclaringClass().equals(this.classType.getRuntimeClass())) : "classType " + this.classType + " and declaring class " + constructor.getDeclaringClass().getName() + " should be same";
        if (!this.reflectionPredicate.test(constructor)) {
            return;
        }
        TypedClassOperation operation = this.instantiateTypes(TypedOperation.forConstructor(constructor));
        if (debug) {
            Log.logPrintf("OperationExtractor.visit: operation=%s for constructor %s%n", operation, constructor);
        }
        this.checkSubTypes(operation);
        if (!this.omitPredicate.shouldOmit(operation)) {
            ExecutableSpecification execSpec;
            if (this.operationSpecifications != null && !(execSpec = this.operationSpecifications.getExecutableSpecification(constructor)).isEmpty()) {
                operation.setExecutableSpecification(execSpec);
            }
            if (debug) {
                Log.logPrintln("OperationExtractor.visit: add operation " + Log.toStringAndClass(operation));
            }
            this.operations.add(operation);
        }
    }

    @Override
    public void visit(@SignatureUnknown Method method) {
        ExecutableSpecification execSpec;
        int declaringClassMods;
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: method=" + method);
        }
        if (!this.reflectionPredicate.test(method)) {
            return;
        }
        TypedClassOperation operation = this.instantiateTypes(TypedOperation.forMethod(method));
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: operation=" + operation);
        }
        this.checkSubTypes(operation);
        if (operation.isStatic() && !Modifier.isPublic(declaringClassMods = method.getDeclaringClass().getModifiers() & Modifier.classModifiers())) {
            operation = operation.getOperationForType(this.classType);
            if (debug) {
                Log.logPrintln("OperationExtractor.visit: operation changed to " + operation);
            }
        }
        if (this.omitPredicate.shouldOmit(operation.getOperationForType(this.classType))) {
            Log.logPrintln("omitPreditate omits " + operation.getOperationForType(this.classType));
            return;
        }
        if (this.operationSpecifications != null && !(execSpec = this.operationSpecifications.getExecutableSpecification(method)).isEmpty()) {
            operation.setExecutableSpecification(execSpec);
        }
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: add operation " + operation);
        }
        this.operations.add(operation);
    }

    @Override
    public void visit(@SignatureUnknown Field field) {
        TypedClassOperation operation;
        assert (field.getDeclaringClass().isAssignableFrom(this.classType.getRuntimeClass())) : "classType " + this.classType + " should be assignable from " + field.getDeclaringClass().getName();
        if (!this.reflectionPredicate.test(field)) {
            return;
        }
        ClassOrInterfaceType declaringType = ClassOrInterfaceType.forClass(field.getDeclaringClass());
        int mods = field.getModifiers() & Modifier.fieldModifiers();
        if (!this.visibilityPredicate.isVisible(field.getDeclaringClass())) {
            if (Modifier.isStatic(mods) && Modifier.isFinal(mods)) {
                return;
            }
            if (!declaringType.isGeneric() || !this.classType.isInstantiationOf(declaringType)) {
                declaringType = this.classType;
            }
        }
        TypedClassOperation getter = this.instantiateTypes(TypedOperation.createGetterForField(field, declaringType));
        this.checkSubTypes(getter);
        if (getter != null) {
            this.operations.add(getter);
        }
        if (!Modifier.isFinal(mods) && (operation = this.instantiateTypes(TypedOperation.createSetterForField(field, declaringType))) != null) {
            this.operations.add(operation);
        }
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> e) {
        NonParameterizedType enumType = NonParameterizedType.forClass(e.getDeclaringClass());
        assert (!enumType.isGeneric()) : "type of enum class cannot be generic";
        EnumConstant op = new EnumConstant(e);
        TypedClassOperation operation = new TypedClassOperation(op, enumType, new TypeTuple(), enumType);
        this.operations.add(operation);
    }

    public @SignatureUnknown Collection<@SignatureUnknown TypedOperation> getOperations() {
        return this.operations;
    }
}

