/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import randoop.operation.NonreceiverTerm;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.reflection.DefaultClassVisitor;
import randoop.sequence.Sequence;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.util.ClassFileConstants;
import randoop.util.MultiMap;

class ClassLiteralExtractor
extends DefaultClassVisitor {
    private @SignatureUnknown MultiMap<@SignatureUnknown ClassOrInterfaceType, @SignatureUnknown Sequence> literalMap;

    ClassLiteralExtractor(@SignatureUnknown MultiMap<@SignatureUnknown ClassOrInterfaceType, @SignatureUnknown Sequence> literalMap) {
        this.literalMap = literalMap;
    }

    @Override
    public void visitBefore(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        List<ClassFileConstants.ConstantSet> constList = Collections.singletonList(ClassFileConstants.getConstants(c.getName()));
        MultiMap<Class<?>, NonreceiverTerm> constantMap = ClassFileConstants.toMap(constList);
        for (Class<?> constantClass : constantMap.keySet()) {
            ClassOrInterfaceType constantType = ClassOrInterfaceType.forClass(constantClass);
            for (NonreceiverTerm term : constantMap.getValues(constantClass)) {
                Sequence seq = new Sequence().extend(TypedOperation.createNonreceiverInitialization(term), new ArrayList<Variable>());
                this.literalMap.add(constantType, seq);
            }
        }
    }
}

